@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedFeatures Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
 * @property cloudWatchMetricsEnabled Whether or not the CloudWatch metrics configuration is enabled.
 * @property supportingAccessPoint Standard access point associated with the Object Lambda Access Point.
 * @property transformationConfigurations List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
 */
public data class ObjectLambdaAccessPointConfiguration(
    public val allowedFeatures: List<String>? = null,
    public val cloudWatchMetricsEnabled: Boolean? = null,
    public val supportingAccessPoint: String,
    public val transformationConfigurations:
    List<ObjectLambdaAccessPointConfigurationTransformationConfiguration>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.ObjectLambdaAccessPointConfiguration):
            ObjectLambdaAccessPointConfiguration = ObjectLambdaAccessPointConfiguration(
            allowedFeatures = javaType.allowedFeatures().map({ args0 -> args0 }),
            cloudWatchMetricsEnabled = javaType.cloudWatchMetricsEnabled().map({ args0 -> args0 }).orElse(null),
            supportingAccessPoint = javaType.supportingAccessPoint(),
            transformationConfigurations = javaType.transformationConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.ObjectLambdaAccessPointConfigurationTransformationConfiguration.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
