@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property functionArn The Amazon Resource Name (ARN) of the AWS Lambda function.
 * @property functionPayload Additional JSON that provides supplemental data to the Lambda function used to transform objects.
 */
public data class
ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda(
    public val functionArn: String,
    public val functionPayload: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda):
            ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda =
            ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda(
                functionArn = javaType.functionArn(),
                functionPayload = javaType.functionPayload().map({ args0 -> args0 }).orElse(null),
            )
    }
}
