@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cloudWatchMetrics Amazon CloudWatch publishing for S3 Storage Lens metrics. See Cloud Watch Metrics below for more details.
 * @property s3BucketDestination The bucket where the S3 Storage Lens metrics export will be located. See S3 Bucket Destination below for more details.
 */
public data class StorageLensConfigurationStorageLensConfigurationDataExport(
    public val cloudWatchMetrics:
    StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetrics? = null,
    public val s3BucketDestination:
    StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.StorageLensConfigurationStorageLensConfigurationDataExport):
            StorageLensConfigurationStorageLensConfigurationDataExport =
            StorageLensConfigurationStorageLensConfigurationDataExport(
                cloudWatchMetrics = javaType.cloudWatchMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                s3BucketDestination = javaType.s3BucketDestination().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
