@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
 * @property arn The Amazon Resource Name (ARN) of the Amazon Web Services organization.
 * @property encryption Encryption of the metrics exports in this bucket. See Encryption below for more details.
 * @property format The export format. Valid values: `CSV`, `Parquet`.
 * @property outputSchemaVersion The schema version of the export file. Valid values: `V_1`.
 * @property prefix The prefix of the destination bucket where the metrics export will be delivered.
 */
public data class StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination(
    public val accountId: String,
    public val arn: String,
    public val encryption:
    StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption? =
        null,
    public val format: String,
    public val outputSchemaVersion: String,
    public val prefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination):
            StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination =
            StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination(
                accountId = javaType.accountId(),
                arn = javaType.arn(),
                encryption = javaType.encryption().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                format = javaType.format(),
                outputSchemaVersion = javaType.outputSchemaVersion(),
                prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
