@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3outposts.kotlin

import com.pulumi.aws.s3outposts.EndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Outposts Endpoint.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3outposts.Endpoint;
 * import com.pulumi.aws.s3outposts.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Endpoint("example", EndpointArgs.builder()
 *             .outpostId(data.aws_outposts_outpost().example().id())
 *             .securityGroupId(aws_security_group.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Outposts Endpoints using Amazon Resource Name (ARN), EC2 Security Group identifier, and EC2 Subnet identifier, separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:s3outposts/endpoint:Endpoint example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/endpoint/0123456789abcdef,sg-12345678,subnet-12345678
 * ```
 * @property accessType Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
 * @property customerOwnedIpv4Pool The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
 * @property outpostId Identifier of the Outpost to contain this endpoint.
 * @property securityGroupId Identifier of the EC2 Security Group.
 * @property subnetId Identifier of the EC2 Subnet.
 */
public data class EndpointArgs(
    public val accessType: Output<String>? = null,
    public val customerOwnedIpv4Pool: Output<String>? = null,
    public val outpostId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3outposts.EndpointArgs> {
    override fun toJava(): com.pulumi.aws.s3outposts.EndpointArgs =
        com.pulumi.aws.s3outposts.EndpointArgs.builder()
            .accessType(accessType?.applyValue({ args0 -> args0 }))
            .customerOwnedIpv4Pool(customerOwnedIpv4Pool?.applyValue({ args0 -> args0 }))
            .outpostId(outpostId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var accessType: Output<String>? = null

    private var customerOwnedIpv4Pool: Output<String>? = null

    private var outpostId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
     */
    @JvmName("espapgsjcsnsledq")
    public suspend fun accessType(`value`: Output<String>) {
        this.accessType = value
    }

    /**
     * @param value The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
     */
    @JvmName("lxtrvcxctohnetgb")
    public suspend fun customerOwnedIpv4Pool(`value`: Output<String>) {
        this.customerOwnedIpv4Pool = value
    }

    /**
     * @param value Identifier of the Outpost to contain this endpoint.
     */
    @JvmName("swbvkmobujbbpbog")
    public suspend fun outpostId(`value`: Output<String>) {
        this.outpostId = value
    }

    /**
     * @param value Identifier of the EC2 Security Group.
     */
    @JvmName("ldrfpsscsdkgwcoc")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Identifier of the EC2 Subnet.
     */
    @JvmName("mjbupuvbltcwgllo")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Type of access for the network connectivity. Valid values are `Private` or `CustomerOwnedIp`.
     */
    @JvmName("xxofrrfpealuyfbw")
    public suspend fun accessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessType = mapped
    }

    /**
     * @param value The ID of a Customer Owned IP Pool. For more on customer owned IP addresses see the [User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/local-rack.html#local-gateway-subnet).
     */
    @JvmName("plqdxdcaeeeixqkh")
    public suspend fun customerOwnedIpv4Pool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerOwnedIpv4Pool = mapped
    }

    /**
     * @param value Identifier of the Outpost to contain this endpoint.
     */
    @JvmName("enudiftcpstbuavm")
    public suspend fun outpostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostId = mapped
    }

    /**
     * @param value Identifier of the EC2 Security Group.
     */
    @JvmName("qdrrudabmyqwgavy")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Identifier of the EC2 Subnet.
     */
    @JvmName("qwrvuvyjqutyqvhb")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        accessType = accessType,
        customerOwnedIpv4Pool = customerOwnedIpv4Pool,
        outpostId = outpostId,
        securityGroupId = securityGroupId,
        subnetId = subnetId,
    )
}
