@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.AppResourceSpec
import com.pulumi.aws.sagemaker.kotlin.outputs.AppResourceSpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [App].
 */
@PulumiTagMarker
public class AppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppArgs = AppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppArgsBuilder.() -> Unit) {
        val builder = AppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): App {
        val builtJavaResource = com.pulumi.aws.sagemaker.App(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return App(builtJavaResource)
    }
}

/**
 * Provides a SageMaker App resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.App;
 * import com.pulumi.aws.sagemaker.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .domainId(aws_sagemaker_domain.example().id())
 *             .userProfileName(aws_sagemaker_user_profile.example().user_profile_name())
 *             .appName("example")
 *             .appType("JupyterServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Apps using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/app:App example arn:aws:sagemaker:us-west-2:012345678912:app/domain-id/user-profile-name/app-type/app-name
 * ```
 *
 */
public class App internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.App,
) : KotlinCustomResource(javaResource, AppMapper) {
    /**
     * The name of the app.
     */
    public val appName: Output<String>
        get() = javaResource.appName().applyValue({ args0 -> args0 })

    /**
     * The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
     */
    public val appType: Output<String>
        get() = javaResource.appType().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the app.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The domain ID.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
     */
    public val resourceSpec: Output<AppResourceSpec>
        get() = javaResource.resourceSpec().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the space. At least one of `user_profile_name` or `space_name` required.
     */
    public val spaceName: Output<String>?
        get() = javaResource.spaceName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The user profile name. At least one of `user_profile_name` or `space_name` required.
     */
    public val userProfileName: Output<String>?
        get() = javaResource.userProfileName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AppMapper : ResourceMapper<App> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.App::class == javaResource::class

    override fun map(javaResource: Resource): App = App(javaResource as com.pulumi.aws.sagemaker.App)
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [App].
 */
public suspend fun app(name: String, block: suspend AppResourceBuilder.() -> Unit): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 */
public fun app(name: String): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    return builder.build()
}
