@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.AppArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.AppResourceSpecArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.AppResourceSpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker App resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.App;
 * import com.pulumi.aws.sagemaker.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .domainId(aws_sagemaker_domain.example().id())
 *             .userProfileName(aws_sagemaker_user_profile.example().user_profile_name())
 *             .appName("example")
 *             .appType("JupyterServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Apps using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/app:App example arn:aws:sagemaker:us-west-2:012345678912:app/domain-id/user-profile-name/app-type/app-name
 * ```
 * @property appName The name of the app.
 * @property appType The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
 * @property domainId The domain ID.
 * @property resourceSpec The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
 * @property spaceName The name of the space. At least one of `user_profile_name` or `space_name` required.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userProfileName The user profile name. At least one of `user_profile_name` or `space_name` required.
 */
public data class AppArgs(
    public val appName: Output<String>? = null,
    public val appType: Output<String>? = null,
    public val domainId: Output<String>? = null,
    public val resourceSpec: Output<AppResourceSpecArgs>? = null,
    public val spaceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userProfileName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.AppArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.AppArgs =
        com.pulumi.aws.sagemaker.AppArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .appType(appType?.applyValue({ args0 -> args0 }))
            .domainId(domainId?.applyValue({ args0 -> args0 }))
            .resourceSpec(resourceSpec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userProfileName(userProfileName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var appType: Output<String>? = null

    private var domainId: Output<String>? = null

    private var resourceSpec: Output<AppResourceSpecArgs>? = null

    private var spaceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userProfileName: Output<String>? = null

    /**
     * @param value The name of the app.
     */
    @JvmName("waiplodbwrvmeyfi")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
     */
    @JvmName("jjbuvynnsgqbrpjx")
    public suspend fun appType(`value`: Output<String>) {
        this.appType = value
    }

    /**
     * @param value The domain ID.
     */
    @JvmName("gvgbqlwggytrtubj")
    public suspend fun domainId(`value`: Output<String>) {
        this.domainId = value
    }

    /**
     * @param value The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
     */
    @JvmName("nysiutddcstrurtk")
    public suspend fun resourceSpec(`value`: Output<AppResourceSpecArgs>) {
        this.resourceSpec = value
    }

    /**
     * @param value The name of the space. At least one of `user_profile_name` or `space_name` required.
     */
    @JvmName("mwyycxfbgcgevpyx")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ldhsapvmaidsllfb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user profile name. At least one of `user_profile_name` or `space_name` required.
     */
    @JvmName("lvvaklcplqeqwakk")
    public suspend fun userProfileName(`value`: Output<String>) {
        this.userProfileName = value
    }

    /**
     * @param value The name of the app.
     */
    @JvmName("sawhdlanyxgrcunl")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The type of app. Valid values are `JupyterServer`, `KernelGateway`, `RStudioServerPro`, `RSessionGateway` and `TensorBoard`.
     */
    @JvmName("nxdpqtxrsccqrjhk")
    public suspend fun appType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appType = mapped
    }

    /**
     * @param value The domain ID.
     */
    @JvmName("loyycsgyrcpqjlbc")
    public suspend fun domainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainId = mapped
    }

    /**
     * @param value The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
     */
    @JvmName("pfgroqdwhlrwqjbv")
    public suspend fun resourceSpec(`value`: AppResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSpec = mapped
    }

    /**
     * @param argument The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.See Resource Spec below.
     */
    @JvmName("vabprurjoxfpfkov")
    public suspend fun resourceSpec(argument: suspend AppResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped = AppResourceSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceSpec = mapped
    }

    /**
     * @param value The name of the space. At least one of `user_profile_name` or `space_name` required.
     */
    @JvmName("chxsgwuoccabymmf")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wxkwoswtwcsteckb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fxmcpbwvrcnbcwqo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user profile name. At least one of `user_profile_name` or `space_name` required.
     */
    @JvmName("hupsovjbqgjblbsx")
    public suspend fun userProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProfileName = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        appName = appName,
        appType = appType,
        domainId = domainId,
        resourceSpec = resourceSpec,
        spaceName = spaceName,
        tags = tags,
        userProfileName = userProfileName,
    )
}
