@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.AppImageConfigArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigKernelGatewayImageConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.AppImageConfigKernelGatewayImageConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker App Image Config resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig("test", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpec(AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder()
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Default File System Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AppImageConfig("test", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .fileSystemConfig()
 *                 .kernelSpec(AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder()
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker App Image Configs using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/appImageConfig:AppImageConfig example example
 * ```
 * @property appImageConfigName The name of the App Image Config.
 * @property kernelGatewayImageConfig The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AppImageConfigArgs(
    public val appImageConfigName: Output<String>? = null,
    public val kernelGatewayImageConfig: Output<AppImageConfigKernelGatewayImageConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.AppImageConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.AppImageConfigArgs =
        com.pulumi.aws.sagemaker.AppImageConfigArgs.builder()
            .appImageConfigName(appImageConfigName?.applyValue({ args0 -> args0 }))
            .kernelGatewayImageConfig(
                kernelGatewayImageConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AppImageConfigArgs].
 */
@PulumiTagMarker
public class AppImageConfigArgsBuilder internal constructor() {
    private var appImageConfigName: Output<String>? = null

    private var kernelGatewayImageConfig: Output<AppImageConfigKernelGatewayImageConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("xgohcqwtvodiyyty")
    public suspend fun appImageConfigName(`value`: Output<String>) {
        this.appImageConfigName = value
    }

    /**
     * @param value The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     */
    @JvmName("ghijsgwhuxntrbmq")
    public suspend
    fun kernelGatewayImageConfig(`value`: Output<AppImageConfigKernelGatewayImageConfigArgs>) {
        this.kernelGatewayImageConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nahjbdxswifxnayy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("nuprjvkatpktjlwg")
    public suspend fun appImageConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appImageConfigName = mapped
    }

    /**
     * @param value The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     */
    @JvmName("dnowtkgijdbkswdh")
    public suspend
    fun kernelGatewayImageConfig(`value`: AppImageConfigKernelGatewayImageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayImageConfig = mapped
    }

    /**
     * @param argument The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app. See Kernel Gateway Image Config details below.
     */
    @JvmName("bfqqxuuhhaxppolt")
    public suspend
    fun kernelGatewayImageConfig(argument: suspend AppImageConfigKernelGatewayImageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppImageConfigKernelGatewayImageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayImageConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jfoyakrdfwsthjpx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hoojyydprfrvqhgn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppImageConfigArgs = AppImageConfigArgs(
        appImageConfigName = appImageConfigName,
        kernelGatewayImageConfig = kernelGatewayImageConfig,
        tags = tags,
    )
}
