@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.CodeRepositoryGitConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.CodeRepositoryGitConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CodeRepository].
 */
@PulumiTagMarker
public class CodeRepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CodeRepositoryArgs = CodeRepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CodeRepositoryArgsBuilder.() -> Unit) {
        val builder = CodeRepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CodeRepository {
        val builtJavaResource = com.pulumi.aws.sagemaker.CodeRepository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CodeRepository(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Code Repository resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CodeRepository("example", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example with Secret
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecret = new Secret("exampleSecret");
 *         var exampleSecretVersion = new SecretVersion("exampleSecretVersion", SecretVersionArgs.builder()
 *             .secretId(exampleSecret.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "example"),
 *                     jsonProperty("password", "example")
 *                 )))
 *             .build());
 *         var exampleCodeRepository = new CodeRepository("exampleCodeRepository", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .secretArn(exampleSecret.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleSecretVersion)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Code Repositories using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/codeRepository:CodeRepository test_code_repository my-code-repo
 * ```
 *
 */
public class CodeRepository internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.CodeRepository,
) : KotlinCustomResource(javaResource, CodeRepositoryMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Code Repository.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the Code Repository (must be unique).
     */
    public val codeRepositoryName: Output<String>
        get() = javaResource.codeRepositoryName().applyValue({ args0 -> args0 })

    /**
     * Specifies details about the repository. see Git Config details below.
     */
    public val gitConfig: Output<CodeRepositoryGitConfig>
        get() = javaResource.gitConfig().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CodeRepositoryMapper : ResourceMapper<CodeRepository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.CodeRepository::class == javaResource::class

    override fun map(javaResource: Resource): CodeRepository = CodeRepository(
        javaResource as
            com.pulumi.aws.sagemaker.CodeRepository,
    )
}

/**
 * @see [CodeRepository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CodeRepository].
 */
public suspend fun codeRepository(
    name: String,
    block: suspend CodeRepositoryResourceBuilder.() -> Unit,
): CodeRepository {
    val builder = CodeRepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CodeRepository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun codeRepository(name: String): CodeRepository {
    val builder = CodeRepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
