@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.CodeRepositoryArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.CodeRepositoryGitConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.CodeRepositoryGitConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Code Repository resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CodeRepository("example", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example with Secret
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecret = new Secret("exampleSecret");
 *         var exampleSecretVersion = new SecretVersion("exampleSecretVersion", SecretVersionArgs.builder()
 *             .secretId(exampleSecret.id())
 *             .secretString(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("username", "example"),
 *                     jsonProperty("password", "example")
 *                 )))
 *             .build());
 *         var exampleCodeRepository = new CodeRepository("exampleCodeRepository", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("example")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .secretArn(exampleSecret.arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleSecretVersion)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Code Repositories using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/codeRepository:CodeRepository test_code_repository my-code-repo
 * ```
 * @property codeRepositoryName The name of the Code Repository (must be unique).
 * @property gitConfig Specifies details about the repository. see Git Config details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CodeRepositoryArgs(
    public val codeRepositoryName: Output<String>? = null,
    public val gitConfig: Output<CodeRepositoryGitConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.CodeRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.CodeRepositoryArgs =
        com.pulumi.aws.sagemaker.CodeRepositoryArgs.builder()
            .codeRepositoryName(codeRepositoryName?.applyValue({ args0 -> args0 }))
            .gitConfig(gitConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CodeRepositoryArgs].
 */
@PulumiTagMarker
public class CodeRepositoryArgsBuilder internal constructor() {
    private var codeRepositoryName: Output<String>? = null

    private var gitConfig: Output<CodeRepositoryGitConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Code Repository (must be unique).
     */
    @JvmName("ivpekchqlnqgnoha")
    public suspend fun codeRepositoryName(`value`: Output<String>) {
        this.codeRepositoryName = value
    }

    /**
     * @param value Specifies details about the repository. see Git Config details below.
     */
    @JvmName("dyhtismtciitvsyd")
    public suspend fun gitConfig(`value`: Output<CodeRepositoryGitConfigArgs>) {
        this.gitConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("egrhpaaaxuwxdfvk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Code Repository (must be unique).
     */
    @JvmName("atpecehkoeoevaue")
    public suspend fun codeRepositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositoryName = mapped
    }

    /**
     * @param value Specifies details about the repository. see Git Config details below.
     */
    @JvmName("hxxfgehklqtlkjmq")
    public suspend fun gitConfig(`value`: CodeRepositoryGitConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitConfig = mapped
    }

    /**
     * @param argument Specifies details about the repository. see Git Config details below.
     */
    @JvmName("vunattehjqolbtcx")
    public suspend fun gitConfig(argument: suspend CodeRepositoryGitConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CodeRepositoryGitConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bottanriidqtnont")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mhgfrywslkdpekfh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CodeRepositoryArgs = CodeRepositoryArgs(
        codeRepositoryName = codeRepositoryName,
        gitConfig = gitConfig,
        tags = tags,
    )
}
