@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityAppSpecification
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityBaselineConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityJobInput
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityJobOutputConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionJobResources
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionNetworkConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionStoppingCondition
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityAppSpecification.Companion.toKotlin as dataQualityJobDefinitionDataQualityAppSpecificationToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityBaselineConfig.Companion.toKotlin as dataQualityJobDefinitionDataQualityBaselineConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityJobInput.Companion.toKotlin as dataQualityJobDefinitionDataQualityJobInputToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityJobOutputConfig.Companion.toKotlin as dataQualityJobDefinitionDataQualityJobOutputConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionJobResources.Companion.toKotlin as dataQualityJobDefinitionJobResourcesToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionNetworkConfig.Companion.toKotlin as dataQualityJobDefinitionNetworkConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionStoppingCondition.Companion.toKotlin as dataQualityJobDefinitionStoppingConditionToKotlin

/**
 * Builder for [DataQualityJobDefinition].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataQualityJobDefinitionArgs = DataQualityJobDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataQualityJobDefinitionArgsBuilder.() -> Unit) {
        val builder = DataQualityJobDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataQualityJobDefinition {
        val builtJavaResource =
            com.pulumi.aws.sagemaker.DataQualityJobDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataQualityJobDefinition(builtJavaResource)
    }
}

/**
 * Provides a SageMaker data quality job definition resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.DataQualityJobDefinition;
 * import com.pulumi.aws.sagemaker.DataQualityJobDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesArgs;
 * import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesClusterConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new DataQualityJobDefinition("test", DataQualityJobDefinitionArgs.builder()
 *             .dataQualityAppSpecification(DataQualityJobDefinitionDataQualityAppSpecificationArgs.builder()
 *                 .imageUri(data.aws_sagemaker_prebuilt_ecr_image().monitor().registry_path())
 *                 .build())
 *             .dataQualityJobInput(DataQualityJobDefinitionDataQualityJobInputArgs.builder()
 *                 .endpointInput(DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs.builder()
 *                     .endpointName(aws_sagemaker_endpoint.my_endpoint().name())
 *                     .build())
 *                 .build())
 *             .dataQualityJobOutputConfig(DataQualityJobDefinitionDataQualityJobOutputConfigArgs.builder()
 *                 .monitoringOutputs(DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs.builder()
 *                     .s3Output(DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs.builder()
 *                         .s3Uri(String.format("https://%s/output", aws_s3_bucket.my_bucket().bucket_regional_domain_name()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .jobResources(DataQualityJobDefinitionJobResourcesArgs.builder()
 *                 .clusterConfig(DataQualityJobDefinitionJobResourcesClusterConfigArgs.builder()
 *                     .instanceCount(1)
 *                     .instanceType("ml.t3.medium")
 *                     .volumeSizeInGb(20)
 *                     .build())
 *                 .build())
 *             .roleArn(aws_iam_role.my_role().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import data quality job definitions using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/dataQualityJobDefinition:DataQualityJobDefinition test_data_quality_job_definition data-quality-job-definition-foo
 * ```
 *
 */
public class DataQualityJobDefinition internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.DataQualityJobDefinition,
) : KotlinCustomResource(javaResource, DataQualityJobDefinitionMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this data quality job definition.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the container that runs the monitoring job. Fields are documented below.
     */
    public val dataQualityAppSpecification:
        Output<DataQualityJobDefinitionDataQualityAppSpecification>
        get() = javaResource.dataQualityAppSpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                dataQualityJobDefinitionDataQualityAppSpecificationToKotlin(args0)
            })
        })

    /**
     * Configures the constraints and baselines for the monitoring job. Fields are documented below.
     */
    public val dataQualityBaselineConfig: Output<DataQualityJobDefinitionDataQualityBaselineConfig>?
        get() = javaResource.dataQualityBaselineConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataQualityJobDefinitionDataQualityBaselineConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A list of inputs for the monitoring job. Fields are documented below.
     */
    public val dataQualityJobInput: Output<DataQualityJobDefinitionDataQualityJobInput>
        get() = javaResource.dataQualityJobInput().applyValue({ args0 ->
            args0.let({ args0 ->
                dataQualityJobDefinitionDataQualityJobInputToKotlin(args0)
            })
        })

    /**
     * The output configuration for monitoring jobs. Fields are documented below.
     */
    public val dataQualityJobOutputConfig: Output<DataQualityJobDefinitionDataQualityJobOutputConfig>
        get() = javaResource.dataQualityJobOutputConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                dataQualityJobDefinitionDataQualityJobOutputConfigToKotlin(args0)
            })
        })

    /**
     * Identifies the resources to deploy for a monitoring job. Fields are documented below.
     */
    public val jobResources: Output<DataQualityJobDefinitionJobResources>
        get() = javaResource.jobResources().applyValue({ args0 ->
            args0.let({ args0 ->
                dataQualityJobDefinitionJobResourcesToKotlin(args0)
            })
        })

    /**
     * The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies networking configuration for the monitoring job. Fields are documented below.
     */
    public val networkConfig: Output<DataQualityJobDefinitionNetworkConfig>?
        get() = javaResource.networkConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataQualityJobDefinitionNetworkConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
     */
    public val stoppingCondition: Output<DataQualityJobDefinitionStoppingCondition>
        get() = javaResource.stoppingCondition().applyValue({ args0 ->
            args0.let({ args0 ->
                dataQualityJobDefinitionStoppingConditionToKotlin(args0)
            })
        })

    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DataQualityJobDefinitionMapper : ResourceMapper<DataQualityJobDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.DataQualityJobDefinition::class == javaResource::class

    override fun map(javaResource: Resource): DataQualityJobDefinition =
        DataQualityJobDefinition(javaResource as com.pulumi.aws.sagemaker.DataQualityJobDefinition)
}

/**
 * @see [DataQualityJobDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataQualityJobDefinition].
 */
public suspend fun dataQualityJobDefinition(
    name: String,
    block: suspend DataQualityJobDefinitionResourceBuilder.() -> Unit,
): DataQualityJobDefinition {
    val builder = DataQualityJobDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataQualityJobDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataQualityJobDefinition(name: String): DataQualityJobDefinition {
    val builder = DataQualityJobDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
