@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.DeviceDevice
import com.pulumi.aws.sagemaker.kotlin.outputs.DeviceDevice.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Device].
 */
@PulumiTagMarker
public class DeviceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceArgs = DeviceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceArgsBuilder.() -> Unit) {
        val builder = DeviceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Device {
        val builtJavaResource = com.pulumi.aws.sagemaker.Device(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Device(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Device resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Device;
 * import com.pulumi.aws.sagemaker.DeviceArgs;
 * import com.pulumi.aws.sagemaker.inputs.DeviceDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Device("example", DeviceArgs.builder()
 *             .deviceFleetName(aws_sagemaker_device_fleet.example().device_fleet_name())
 *             .device(DeviceDeviceArgs.builder()
 *                 .deviceName("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Devices using the `device-fleet-name/device-name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/device:Device example my-fleet/my-device
 * ```
 *
 */
public class Device internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Device,
) : KotlinCustomResource(javaResource, DeviceMapper) {
    public val agentVersion: Output<String>
        get() = javaResource.agentVersion().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Device.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The device to register with SageMaker Edge Manager. See Device details below.
     */
    public val device: Output<DeviceDevice>
        get() = javaResource.device().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the Device Fleet.
     */
    public val deviceFleetName: Output<String>
        get() = javaResource.deviceFleetName().applyValue({ args0 -> args0 })
}

public object DeviceMapper : ResourceMapper<Device> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Device::class == javaResource::class

    override fun map(javaResource: Resource): Device = Device(
        javaResource as
            com.pulumi.aws.sagemaker.Device,
    )
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Device].
 */
public suspend fun device(name: String, block: suspend DeviceResourceBuilder.() -> Unit): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 */
public fun device(name: String): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    return builder.build()
}
