@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.DeviceArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.DeviceDeviceArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DeviceDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Device resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Device;
 * import com.pulumi.aws.sagemaker.DeviceArgs;
 * import com.pulumi.aws.sagemaker.inputs.DeviceDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Device("example", DeviceArgs.builder()
 *             .deviceFleetName(aws_sagemaker_device_fleet.example().device_fleet_name())
 *             .device(DeviceDeviceArgs.builder()
 *                 .deviceName("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Devices using the `device-fleet-name/device-name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/device:Device example my-fleet/my-device
 * ```
 * @property device The device to register with SageMaker Edge Manager. See Device details below.
 * @property deviceFleetName The name of the Device Fleet.
 */
public data class DeviceArgs(
    public val device: Output<DeviceDeviceArgs>? = null,
    public val deviceFleetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.DeviceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.DeviceArgs =
        com.pulumi.aws.sagemaker.DeviceArgs.builder()
            .device(device?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceFleetName(deviceFleetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceArgs].
 */
@PulumiTagMarker
public class DeviceArgsBuilder internal constructor() {
    private var device: Output<DeviceDeviceArgs>? = null

    private var deviceFleetName: Output<String>? = null

    /**
     * @param value The device to register with SageMaker Edge Manager. See Device details below.
     */
    @JvmName("gpknqblbaucgpewc")
    public suspend fun device(`value`: Output<DeviceDeviceArgs>) {
        this.device = value
    }

    /**
     * @param value The name of the Device Fleet.
     */
    @JvmName("mkvikveqgqmkdkgo")
    public suspend fun deviceFleetName(`value`: Output<String>) {
        this.deviceFleetName = value
    }

    /**
     * @param value The device to register with SageMaker Edge Manager. See Device details below.
     */
    @JvmName("yvfwlhdkwjucwvvg")
    public suspend fun device(`value`: DeviceDeviceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param argument The device to register with SageMaker Edge Manager. See Device details below.
     */
    @JvmName("pprybucfqaynbcjb")
    public suspend fun device(argument: suspend DeviceDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = DeviceDeviceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.device = mapped
    }

    /**
     * @param value The name of the Device Fleet.
     */
    @JvmName("rhrujccyrygigjts")
    public suspend fun deviceFleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceFleetName = mapped
    }

    internal fun build(): DeviceArgs = DeviceArgs(
        device = device,
        deviceFleetName = deviceFleetName,
    )
}
