@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.DeviceFleetArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.DeviceFleetOutputConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DeviceFleetOutputConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Device Fleet resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.DeviceFleet;
 * import com.pulumi.aws.sagemaker.DeviceFleetArgs;
 * import com.pulumi.aws.sagemaker.inputs.DeviceFleetOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DeviceFleet("example", DeviceFleetArgs.builder()
 *             .deviceFleetName("example")
 *             .roleArn(aws_iam_role.test().arn())
 *             .outputConfig(DeviceFleetOutputConfigArgs.builder()
 *                 .s3OutputLocation(String.format("s3://%s/prefix/", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Device Fleets using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/deviceFleet:DeviceFleet example my-fleet
 * ```
 * @property description A description of the fleet.
 * @property deviceFleetName The name of the Device Fleet (must be unique).
 * @property enableIotRoleAlias Whether to create an AWS IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
 * @property outputConfig Specifies details about the repository. see Output Config details below.
 * @property roleArn The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DeviceFleetArgs(
    public val description: Output<String>? = null,
    public val deviceFleetName: Output<String>? = null,
    public val enableIotRoleAlias: Output<Boolean>? = null,
    public val outputConfig: Output<DeviceFleetOutputConfigArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.DeviceFleetArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.DeviceFleetArgs =
        com.pulumi.aws.sagemaker.DeviceFleetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceFleetName(deviceFleetName?.applyValue({ args0 -> args0 }))
            .enableIotRoleAlias(enableIotRoleAlias?.applyValue({ args0 -> args0 }))
            .outputConfig(outputConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeviceFleetArgs].
 */
@PulumiTagMarker
public class DeviceFleetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var deviceFleetName: Output<String>? = null

    private var enableIotRoleAlias: Output<Boolean>? = null

    private var outputConfig: Output<DeviceFleetOutputConfigArgs>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description of the fleet.
     */
    @JvmName("lwamqqtfsyoddkrr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Device Fleet (must be unique).
     */
    @JvmName("xgqoaqikfigjykbd")
    public suspend fun deviceFleetName(`value`: Output<String>) {
        this.deviceFleetName = value
    }

    /**
     * @param value Whether to create an AWS IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
     */
    @JvmName("vscpvyjlahluiamv")
    public suspend fun enableIotRoleAlias(`value`: Output<Boolean>) {
        this.enableIotRoleAlias = value
    }

    /**
     * @param value Specifies details about the repository. see Output Config details below.
     */
    @JvmName("iqpfngfugmwqqdrl")
    public suspend fun outputConfig(`value`: Output<DeviceFleetOutputConfigArgs>) {
        this.outputConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
     */
    @JvmName("angtjixenidjgdis")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("usgeobnxsihkpssw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description of the fleet.
     */
    @JvmName("wclsmkwsnclswdsx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Device Fleet (must be unique).
     */
    @JvmName("tyuifgplfmbehqai")
    public suspend fun deviceFleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceFleetName = mapped
    }

    /**
     * @param value Whether to create an AWS IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
     */
    @JvmName("dsodmddmmpjbemnn")
    public suspend fun enableIotRoleAlias(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIotRoleAlias = mapped
    }

    /**
     * @param value Specifies details about the repository. see Output Config details below.
     */
    @JvmName("qabivbdvthmoxjac")
    public suspend fun outputConfig(`value`: DeviceFleetOutputConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputConfig = mapped
    }

    /**
     * @param argument Specifies details about the repository. see Output Config details below.
     */
    @JvmName("qsxulyrcsxeiphxm")
    public suspend fun outputConfig(argument: suspend DeviceFleetOutputConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DeviceFleetOutputConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputConfig = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
     */
    @JvmName("lckpidnaaxrawnib")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vbcshgkuxlgnyabk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("opltateikffbsdar")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeviceFleetArgs = DeviceFleetArgs(
        description = description,
        deviceFleetName = deviceFleetName,
        enableIotRoleAlias = enableIotRoleAlias,
        outputConfig = outputConfig,
        roleArn = roleArn,
        tags = tags,
    )
}
