@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDomainSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainRetentionPolicy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettings.Companion.toKotlin as domainDefaultSpaceSettingsToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettings.Companion.toKotlin as domainDefaultUserSettingsToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainDomainSettings.Companion.toKotlin as domainDomainSettingsToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.DomainRetentionPolicy.Companion.toKotlin as domainRetentionPolicyToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.sagemaker.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Domain resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("sagemaker.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .path("/")
 *             .assumeRolePolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(aws_vpc.example().id())
 *             .subnetIds(aws_subnet.example().id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(exampleRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using Custom Images
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Image;
 * import com.pulumi.aws.sagemaker.ImageArgs;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs;
 * import com.pulumi.aws.sagemaker.ImageVersion;
 * import com.pulumi.aws.sagemaker.ImageVersionArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleImage = new Image("exampleImage", ImageArgs.builder()
 *             .imageName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 *         var exampleAppImageConfig = new AppImageConfig("exampleAppImageConfig", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpec(AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder()
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleImageVersion = new ImageVersion("exampleImageVersion", ImageVersionArgs.builder()
 *             .imageName(exampleImage.id())
 *             .baseImage("base-image")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(aws_vpc.example().id())
 *             .subnetIds(aws_subnet.example().id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(aws_iam_role.example().arn())
 *                 .kernelGatewayAppSettings(DomainDefaultUserSettingsKernelGatewayAppSettingsArgs.builder()
 *                     .customImages(DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs.builder()
 *                         .appImageConfigName(exampleAppImageConfig.appImageConfigName())
 *                         .imageName(exampleImageVersion.imageName())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Domains using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/domain:Domain test_domain d-8jgsjtilstu8
 * ```
 *
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
     */
    public val appNetworkAccessType: Output<String>?
        get() = javaResource.appNetworkAccessType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
     */
    public val appSecurityGroupManagement: Output<String>?
        get() = javaResource.appSecurityGroupManagement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Domain.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
     */
    public val authMode: Output<String>
        get() = javaResource.authMode().applyValue({ args0 -> args0 })

    /**
     * The default space settings. See Default Space Settings below.
     */
    public val defaultSpaceSettings: Output<DomainDefaultSpaceSettings>?
        get() = javaResource.defaultSpaceSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainDefaultSpaceSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The default user settings. See Default User Settings below.
     */
    public val defaultUserSettings: Output<DomainDefaultUserSettings>
        get() = javaResource.defaultUserSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                domainDefaultUserSettingsToKotlin(args0)
            })
        })

    /**
     * The domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The domain's settings.
     */
    public val domainSettings: Output<DomainDomainSettings>?
        get() = javaResource.domainSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainDomainSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     */
    public val homeEfsFileSystemId: Output<String>
        get() = javaResource.homeEfsFileSystemId().applyValue({ args0 -> args0 })

    /**
     * The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
     */
    public val retentionPolicy: Output<DomainRetentionPolicy>?
        get() = javaResource.retentionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainRetentionPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ID of the security group that authorizes traffic between the RSessionGateway apps and the RStudioServerPro app.
     */
    public val securityGroupIdForDomainBoundary: Output<String>
        get() = javaResource.securityGroupIdForDomainBoundary().applyValue({ args0 -> args0 })

    /**
     * The SSO managed application instance ID.
     */
    public val singleSignOnManagedApplicationInstanceId: Output<String>
        get() = javaResource.singleSignOnManagedApplicationInstanceId().applyValue({ args0 -> args0 })

    /**
     * The VPC subnets that Studio uses for communication.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The domain's URL.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * The following arguments are optional:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.sagemaker.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
