@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.DomainArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultSpaceSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultSpaceSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultUserSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultUserSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDomainSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDomainSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainRetentionPolicyArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainRetentionPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Domain resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("sagemaker.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .path("/")
 *             .assumeRolePolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(aws_vpc.example().id())
 *             .subnetIds(aws_subnet.example().id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(exampleRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using Custom Images
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Image;
 * import com.pulumi.aws.sagemaker.ImageArgs;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs;
 * import com.pulumi.aws.sagemaker.ImageVersion;
 * import com.pulumi.aws.sagemaker.ImageVersionArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleImage = new Image("exampleImage", ImageArgs.builder()
 *             .imageName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 *         var exampleAppImageConfig = new AppImageConfig("exampleAppImageConfig", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpec(AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder()
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleImageVersion = new ImageVersion("exampleImageVersion", ImageVersionArgs.builder()
 *             .imageName(exampleImage.id())
 *             .baseImage("base-image")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(aws_vpc.example().id())
 *             .subnetIds(aws_subnet.example().id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(aws_iam_role.example().arn())
 *                 .kernelGatewayAppSettings(DomainDefaultUserSettingsKernelGatewayAppSettingsArgs.builder()
 *                     .customImages(DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs.builder()
 *                         .appImageConfigName(exampleAppImageConfig.appImageConfigName())
 *                         .imageName(exampleImageVersion.imageName())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Domains using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/domain:Domain test_domain d-8jgsjtilstu8
 * ```
 * @property appNetworkAccessType Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
 * @property appSecurityGroupManagement The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
 * @property authMode The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
 * @property defaultSpaceSettings The default space settings. See Default Space Settings below.
 * @property defaultUserSettings The default user settings. See Default User Settings below.
 * @property domainName The domain name.
 * @property domainSettings The domain's settings.
 * @property kmsKeyId The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
 * @property retentionPolicy The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
 * @property subnetIds The VPC subnets that Studio uses for communication.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
 * The following arguments are optional:
 */
public data class DomainArgs(
    public val appNetworkAccessType: Output<String>? = null,
    public val appSecurityGroupManagement: Output<String>? = null,
    public val authMode: Output<String>? = null,
    public val defaultSpaceSettings: Output<DomainDefaultSpaceSettingsArgs>? = null,
    public val defaultUserSettings: Output<DomainDefaultUserSettingsArgs>? = null,
    public val domainName: Output<String>? = null,
    public val domainSettings: Output<DomainDomainSettingsArgs>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val retentionPolicy: Output<DomainRetentionPolicyArgs>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.DomainArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.DomainArgs =
        com.pulumi.aws.sagemaker.DomainArgs.builder()
            .appNetworkAccessType(appNetworkAccessType?.applyValue({ args0 -> args0 }))
            .appSecurityGroupManagement(appSecurityGroupManagement?.applyValue({ args0 -> args0 }))
            .authMode(authMode?.applyValue({ args0 -> args0 }))
            .defaultSpaceSettings(
                defaultSpaceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultUserSettings(
                defaultUserSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainSettings(domainSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .retentionPolicy(retentionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var appNetworkAccessType: Output<String>? = null

    private var appSecurityGroupManagement: Output<String>? = null

    private var authMode: Output<String>? = null

    private var defaultSpaceSettings: Output<DomainDefaultSpaceSettingsArgs>? = null

    private var defaultUserSettings: Output<DomainDefaultUserSettingsArgs>? = null

    private var domainName: Output<String>? = null

    private var domainSettings: Output<DomainDomainSettingsArgs>? = null

    private var kmsKeyId: Output<String>? = null

    private var retentionPolicy: Output<DomainRetentionPolicyArgs>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
     */
    @JvmName("mamlpyglsginvsgx")
    public suspend fun appNetworkAccessType(`value`: Output<String>) {
        this.appNetworkAccessType = value
    }

    /**
     * @param value The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
     */
    @JvmName("pcqiylmglulnrnfp")
    public suspend fun appSecurityGroupManagement(`value`: Output<String>) {
        this.appSecurityGroupManagement = value
    }

    /**
     * @param value The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
     */
    @JvmName("cjberjgsbdanlryd")
    public suspend fun authMode(`value`: Output<String>) {
        this.authMode = value
    }

    /**
     * @param value The default space settings. See Default Space Settings below.
     */
    @JvmName("lnsurtlulxqgddsh")
    public suspend fun defaultSpaceSettings(`value`: Output<DomainDefaultSpaceSettingsArgs>) {
        this.defaultSpaceSettings = value
    }

    /**
     * @param value The default user settings. See Default User Settings below.
     */
    @JvmName("uyfitldwwqrlsxta")
    public suspend fun defaultUserSettings(`value`: Output<DomainDefaultUserSettingsArgs>) {
        this.defaultUserSettings = value
    }

    /**
     * @param value The domain name.
     */
    @JvmName("aibqotgcvoxqgmsw")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The domain's settings.
     */
    @JvmName("onikkojyuxjxqvgg")
    public suspend fun domainSettings(`value`: Output<DomainDomainSettingsArgs>) {
        this.domainSettings = value
    }

    /**
     * @param value The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     */
    @JvmName("drbbtniroylbhgod")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
     */
    @JvmName("rtrxohewynotlpic")
    public suspend fun retentionPolicy(`value`: Output<DomainRetentionPolicyArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value The VPC subnets that Studio uses for communication.
     */
    @JvmName("qksaqvvyblwffkxx")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("xvweqpofhfporxwp")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The VPC subnets that Studio uses for communication.
     */
    @JvmName("xmupokojgwskgjqi")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uohjotukjlxpcptr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * The following arguments are optional:
     */
    @JvmName("sjuwmiqmnmjxxkpu")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
     */
    @JvmName("ojrfxhlwskaaggtp")
    public suspend fun appNetworkAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appNetworkAccessType = mapped
    }

    /**
     * @param value The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
     */
    @JvmName("ixirbcejnsxcjnxw")
    public suspend fun appSecurityGroupManagement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSecurityGroupManagement = mapped
    }

    /**
     * @param value The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
     */
    @JvmName("bfirvdrabyxfreho")
    public suspend fun authMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value The default space settings. See Default Space Settings below.
     */
    @JvmName("enmfuwspkawwvsuq")
    public suspend fun defaultSpaceSettings(`value`: DomainDefaultSpaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSpaceSettings = mapped
    }

    /**
     * @param argument The default space settings. See Default Space Settings below.
     */
    @JvmName("vaooexqsskpiknfp")
    public suspend
    fun defaultSpaceSettings(argument: suspend DomainDefaultSpaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultSpaceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultSpaceSettings = mapped
    }

    /**
     * @param value The default user settings. See Default User Settings below.
     */
    @JvmName("efikfidqugeaqcwg")
    public suspend fun defaultUserSettings(`value`: DomainDefaultUserSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultUserSettings = mapped
    }

    /**
     * @param argument The default user settings. See Default User Settings below.
     */
    @JvmName("tqbiiyugnocvieqx")
    public suspend
    fun defaultUserSettings(argument: suspend DomainDefaultUserSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultUserSettings = mapped
    }

    /**
     * @param value The domain name.
     */
    @JvmName("rcakedghctcvahek")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The domain's settings.
     */
    @JvmName("uoymiscgggwlhpmx")
    public suspend fun domainSettings(`value`: DomainDomainSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainSettings = mapped
    }

    /**
     * @param argument The domain's settings.
     */
    @JvmName("rgarnenxspwafciq")
    public suspend fun domainSettings(argument: suspend DomainDomainSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDomainSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainSettings = mapped
    }

    /**
     * @param value The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     */
    @JvmName("tuqdwkpehrehbuhb")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
     */
    @JvmName("swtmjydfvcntdkjv")
    public suspend fun retentionPolicy(`value`: DomainRetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
     */
    @JvmName("mbamlwankvehermy")
    public suspend
    fun retentionPolicy(argument: suspend DomainRetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DomainRetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    /**
     * @param value The VPC subnets that Studio uses for communication.
     */
    @JvmName("rrjyqrtspardoiyr")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The VPC subnets that Studio uses for communication.
     */
    @JvmName("qtfemtpjehkytmsr")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pnhswrxrxxvlsyce")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("erhqqnnopxlmjhvj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * The following arguments are optional:
     */
    @JvmName("akbsvupkoddftyhu")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        appNetworkAccessType = appNetworkAccessType,
        appSecurityGroupManagement = appSecurityGroupManagement,
        authMode = authMode,
        defaultSpaceSettings = defaultSpaceSettings,
        defaultUserSettings = defaultUserSettings,
        domainName = domainName,
        domainSettings = domainSettings,
        kmsKeyId = kmsKeyId,
        retentionPolicy = retentionPolicy,
        subnetIds = subnetIds,
        tags = tags,
        vpcId = vpcId,
    )
}
