@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource = com.pulumi.aws.sagemaker.Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Endpoint(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Endpoint resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Endpoint;
 * import com.pulumi.aws.sagemaker.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointConfigName(aws_sagemaker_endpoint_configuration.ec().name())
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import endpoints using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/endpoint:Endpoint test_endpoint my-endpoint
 * ```
 *
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. See Deployment Config.
     */
    public val deploymentConfig: Output<EndpointDeploymentConfig>?
        get() = javaResource.deploymentConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the endpoint configuration to use.
     */
    public val endpointConfigName: Output<String>
        get() = javaResource.endpointConfigName().applyValue({ args0 -> args0 })

    /**
     * The name of the endpoint. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.aws.sagemaker.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit):
    Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
