@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationAsyncInferenceConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationDataCaptureConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationProductionVariant
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationShadowProductionVariant
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationAsyncInferenceConfig.Companion.toKotlin as endpointConfigurationAsyncInferenceConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationDataCaptureConfig.Companion.toKotlin as endpointConfigurationDataCaptureConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationProductionVariant.Companion.toKotlin as endpointConfigurationProductionVariantToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationShadowProductionVariant.Companion.toKotlin as endpointConfigurationShadowProductionVariantToKotlin

/**
 * Builder for [EndpointConfiguration].
 */
@PulumiTagMarker
public class EndpointConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointConfigurationArgs = EndpointConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointConfigurationArgsBuilder.() -> Unit) {
        val builder = EndpointConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EndpointConfiguration {
        val builtJavaResource = com.pulumi.aws.sagemaker.EndpointConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointConfiguration(builtJavaResource)
    }
}

/**
 * Provides a SageMaker endpoint configuration resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.EndpointConfiguration;
 * import com.pulumi.aws.sagemaker.EndpointConfigurationArgs;
 * import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec = new EndpointConfiguration("ec", EndpointConfigurationArgs.builder()
 *             .productionVariants(EndpointConfigurationProductionVariantArgs.builder()
 *                 .variantName("variant-1")
 *                 .modelName(aws_sagemaker_model.m().name())
 *                 .initialInstanceCount(1)
 *                 .instanceType("ml.t2.medium")
 *                 .build())
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import endpoint configurations using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/endpointConfiguration:EndpointConfiguration test_endpoint_config endpoint-config-foo
 * ```
 *
 */
public class EndpointConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.EndpointConfiguration,
) : KotlinCustomResource(javaResource, EndpointConfigurationMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this endpoint configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     */
    public val asyncInferenceConfig: Output<EndpointConfigurationAsyncInferenceConfig>?
        get() = javaResource.asyncInferenceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    endpointConfigurationAsyncInferenceConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the parameters to capture input/output of SageMaker models endpoints. Fields are documented below.
     */
    public val dataCaptureConfig: Output<EndpointConfigurationDataCaptureConfig>?
        get() = javaResource.dataCaptureConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointConfigurationDataCaptureConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     */
    public val kmsKeyArn: Output<String>?
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the endpoint configuration. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique endpoint configuration name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    public val productionVariants: Output<List<EndpointConfigurationProductionVariant>>
        get() = javaResource.productionVariants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> endpointConfigurationProductionVariantToKotlin(args0) })
            })
        })

    /**
     * Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    public val shadowProductionVariants: Output<List<EndpointConfigurationShadowProductionVariant>>?
        get() = javaResource.shadowProductionVariants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        endpointConfigurationShadowProductionVariantToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EndpointConfigurationMapper : ResourceMapper<EndpointConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.EndpointConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): EndpointConfiguration =
        EndpointConfiguration(javaResource as com.pulumi.aws.sagemaker.EndpointConfiguration)
}

/**
 * @see [EndpointConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointConfiguration].
 */
public suspend fun endpointConfiguration(
    name: String,
    block: suspend EndpointConfigurationResourceBuilder.() -> Unit,
): EndpointConfiguration {
    val builder = EndpointConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointConfiguration(name: String): EndpointConfiguration {
    val builder = EndpointConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
