@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.EndpointConfigurationArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationAsyncInferenceConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationAsyncInferenceConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationDataCaptureConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationDataCaptureConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationProductionVariantArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationProductionVariantArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationShadowProductionVariantArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointConfigurationShadowProductionVariantArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker endpoint configuration resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.EndpointConfiguration;
 * import com.pulumi.aws.sagemaker.EndpointConfigurationArgs;
 * import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec = new EndpointConfiguration("ec", EndpointConfigurationArgs.builder()
 *             .productionVariants(EndpointConfigurationProductionVariantArgs.builder()
 *                 .variantName("variant-1")
 *                 .modelName(aws_sagemaker_model.m().name())
 *                 .initialInstanceCount(1)
 *                 .instanceType("ml.t2.medium")
 *                 .build())
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import endpoint configurations using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/endpointConfiguration:EndpointConfiguration test_endpoint_config endpoint-config-foo
 * ```
 * @property asyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous inference.
 * @property dataCaptureConfig Specifies the parameters to capture input/output of SageMaker models endpoints. Fields are documented below.
 * @property kmsKeyArn Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
 * @property name The name of the endpoint configuration. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique endpoint configuration name beginning with the specified prefix. Conflicts with `name`.
 * @property productionVariants An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
 * @property shadowProductionVariants Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EndpointConfigurationArgs(
    public val asyncInferenceConfig: Output<EndpointConfigurationAsyncInferenceConfigArgs>? = null,
    public val dataCaptureConfig: Output<EndpointConfigurationDataCaptureConfigArgs>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val productionVariants: Output<List<EndpointConfigurationProductionVariantArgs>>? = null,
    public val shadowProductionVariants:
    Output<List<EndpointConfigurationShadowProductionVariantArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.EndpointConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.EndpointConfigurationArgs =
        com.pulumi.aws.sagemaker.EndpointConfigurationArgs.builder()
            .asyncInferenceConfig(
                asyncInferenceConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataCaptureConfig(dataCaptureConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .productionVariants(
                productionVariants?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .shadowProductionVariants(
                shadowProductionVariants?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EndpointConfigurationArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationArgsBuilder internal constructor() {
    private var asyncInferenceConfig: Output<EndpointConfigurationAsyncInferenceConfigArgs>? = null

    private var dataCaptureConfig: Output<EndpointConfigurationDataCaptureConfigArgs>? = null

    private var kmsKeyArn: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var productionVariants: Output<List<EndpointConfigurationProductionVariantArgs>>? = null

    private var shadowProductionVariants:
        Output<List<EndpointConfigurationShadowProductionVariantArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @JvmName("qdjagnjnvexwgcqn")
    public suspend
    fun asyncInferenceConfig(`value`: Output<EndpointConfigurationAsyncInferenceConfigArgs>) {
        this.asyncInferenceConfig = value
    }

    /**
     * @param value Specifies the parameters to capture input/output of SageMaker models endpoints. Fields are documented below.
     */
    @JvmName("aqlvvdpdvgccxxwp")
    public suspend
    fun dataCaptureConfig(`value`: Output<EndpointConfigurationDataCaptureConfigArgs>) {
        this.dataCaptureConfig = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     */
    @JvmName("xuwklhattxeiwaxq")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The name of the endpoint configuration. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("vysxdfpkxldgyhff")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique endpoint configuration name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("xmsdcvvndkreobhv")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    @JvmName("ajwtytxmnpsfxkyf")
    public suspend
    fun productionVariants(`value`: Output<List<EndpointConfigurationProductionVariantArgs>>) {
        this.productionVariants = value
    }

    @JvmName("rfowjajnidpqwpbl")
    public suspend fun productionVariants(
        vararg
        values: Output<EndpointConfigurationProductionVariantArgs>,
    ) {
        this.productionVariants = Output.all(values.asList())
    }

    /**
     * @param values An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    @JvmName("myjvgqmcisaikaoj")
    public suspend
    fun productionVariants(values: List<Output<EndpointConfigurationProductionVariantArgs>>) {
        this.productionVariants = Output.all(values)
    }

    /**
     * @param value Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    @JvmName("ofbrtkcmmwuxlmgf")
    public suspend
    fun shadowProductionVariants(`value`: Output<List<EndpointConfigurationShadowProductionVariantArgs>>) {
        this.shadowProductionVariants = value
    }

    @JvmName("qpcarluvsammderv")
    public suspend fun shadowProductionVariants(
        vararg
        values: Output<EndpointConfigurationShadowProductionVariantArgs>,
    ) {
        this.shadowProductionVariants = Output.all(values.asList())
    }

    /**
     * @param values Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    @JvmName("xygxngtgaqyxdyqj")
    public suspend
    fun shadowProductionVariants(values: List<Output<EndpointConfigurationShadowProductionVariantArgs>>) {
        this.shadowProductionVariants = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sqrkjdwerkictknh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @JvmName("fekvckwweukjihak")
    public suspend fun asyncInferenceConfig(`value`: EndpointConfigurationAsyncInferenceConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asyncInferenceConfig = mapped
    }

    /**
     * @param argument Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @JvmName("echsbdghpdppusta")
    public suspend
    fun asyncInferenceConfig(argument: suspend EndpointConfigurationAsyncInferenceConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointConfigurationAsyncInferenceConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.asyncInferenceConfig = mapped
    }

    /**
     * @param value Specifies the parameters to capture input/output of SageMaker models endpoints. Fields are documented below.
     */
    @JvmName("bprmitjrxdewynva")
    public suspend fun dataCaptureConfig(`value`: EndpointConfigurationDataCaptureConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCaptureConfig = mapped
    }

    /**
     * @param argument Specifies the parameters to capture input/output of SageMaker models endpoints. Fields are documented below.
     */
    @JvmName("nrpuytelnlmpuuwn")
    public suspend
    fun dataCaptureConfig(argument: suspend EndpointConfigurationDataCaptureConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointConfigurationDataCaptureConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataCaptureConfig = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     */
    @JvmName("hbwoapwdrvpjocqg")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The name of the endpoint configuration. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("frdyaxknhfcwxvyh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique endpoint configuration name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("mvhjrkkdlgpmhqvg")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    @JvmName("bnaocnsuonccnaxg")
    public suspend
    fun productionVariants(`value`: List<EndpointConfigurationProductionVariantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productionVariants = mapped
    }

    /**
     * @param argument An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    @JvmName("fijaxugsmupphpkh")
    public suspend
    fun productionVariants(argument: List<suspend EndpointConfigurationProductionVariantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointConfigurationProductionVariantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.productionVariants = mapped
    }

    /**
     * @param argument An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    @JvmName("kodwcjyjfkjdwhwk")
    public suspend fun productionVariants(
        vararg
        argument: suspend EndpointConfigurationProductionVariantArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointConfigurationProductionVariantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.productionVariants = mapped
    }

    /**
     * @param argument An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    @JvmName("dnojdhjljqdivkbv")
    public suspend
    fun productionVariants(argument: suspend EndpointConfigurationProductionVariantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointConfigurationProductionVariantArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.productionVariants = mapped
    }

    /**
     * @param values An list of ProductionVariant objects, one for each model that you want to host at this endpoint. Fields are documented below.
     */
    @JvmName("spgbojypkftjxakj")
    public suspend fun productionVariants(vararg values: EndpointConfigurationProductionVariantArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productionVariants = mapped
    }

    /**
     * @param value Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    @JvmName("mmacpghjibjaatdc")
    public suspend
    fun shadowProductionVariants(`value`: List<EndpointConfigurationShadowProductionVariantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shadowProductionVariants = mapped
    }

    /**
     * @param argument Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    @JvmName("clbptdpbmwjcigpc")
    public suspend
    fun shadowProductionVariants(argument: List<suspend EndpointConfigurationShadowProductionVariantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointConfigurationShadowProductionVariantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shadowProductionVariants = mapped
    }

    /**
     * @param argument Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    @JvmName("fgxlpnbudmljvwqu")
    public suspend fun shadowProductionVariants(
        vararg
        argument: suspend EndpointConfigurationShadowProductionVariantArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointConfigurationShadowProductionVariantArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shadowProductionVariants = mapped
    }

    /**
     * @param argument Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    @JvmName("bldsqkpmvodaqacl")
    public suspend
    fun shadowProductionVariants(argument: suspend EndpointConfigurationShadowProductionVariantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointConfigurationShadowProductionVariantArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.shadowProductionVariants = mapped
    }

    /**
     * @param values Array of ProductionVariant objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ProductionVariants.If you use this field, you can only specify one variant for ProductionVariants and one variant for ShadowProductionVariants. Fields are documented below.
     */
    @JvmName("yccvjdaxsogkabcc")
    public suspend fun shadowProductionVariants(
        vararg
        values: EndpointConfigurationShadowProductionVariantArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shadowProductionVariants = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("shhrqobdhxqmvnuo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vkrltkfovppjxoql")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EndpointConfigurationArgs = EndpointConfigurationArgs(
        asyncInferenceConfig = asyncInferenceConfig,
        dataCaptureConfig = dataCaptureConfig,
        kmsKeyArn = kmsKeyArn,
        name = name,
        namePrefix = namePrefix,
        productionVariants = productionVariants,
        shadowProductionVariants = shadowProductionVariants,
        tags = tags,
    )
}
