@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopActivationConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopRequestSource
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionOutputConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopActivationConfig.Companion.toKotlin as flowDefinitionHumanLoopActivationConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopConfig.Companion.toKotlin as flowDefinitionHumanLoopConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopRequestSource.Companion.toKotlin as flowDefinitionHumanLoopRequestSourceToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionOutputConfig.Companion.toKotlin as flowDefinitionOutputConfigToKotlin

/**
 * Builder for [FlowDefinition].
 */
@PulumiTagMarker
public class FlowDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowDefinitionArgs = FlowDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowDefinitionArgsBuilder.() -> Unit) {
        val builder = FlowDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FlowDefinition {
        val builtJavaResource = com.pulumi.aws.sagemaker.FlowDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FlowDefinition(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Flow Definition resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(aws_sagemaker_human_task_ui.example().arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(aws_sagemaker_workteam.example().arn())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Public Workteam Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(aws_sagemaker_human_task_ui.example().arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(String.format("arn:aws:sagemaker:%s:394669845002:workteam/public-crowd/default", data.aws_region().current().name()))
 *                 .publicWorkforceTaskPrice(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs.builder()
 *                     .amountInUsd(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs.builder()
 *                         .cents(1)
 *                         .tenthFractionsOfACent(2)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Human Loop Activation Config Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(aws_sagemaker_human_task_ui.example().arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(aws_sagemaker_workteam.example().arn())
 *                 .build())
 *             .humanLoopRequestSource(FlowDefinitionHumanLoopRequestSourceArgs.builder()
 *                 .awsManagedHumanLoopRequestSource("AWS/Textract/AnalyzeDocument/Forms/V1")
 *                 .build())
 *             .humanLoopActivationConfig(FlowDefinitionHumanLoopActivationConfigArgs.builder()
 *                 .humanLoopActivationConditionsConfig(FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs.builder()
 *                     .humanLoopActivationConditions("""
 *         {
 * 			"Conditions": [
 * 			  {
 * 				"ConditionType": "Sampling",
 * 				"ConditionParameters": {
 * 				  "RandomSamplingPercentage": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 *                     """)
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Flow Definitions using the `flow_definition_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/flowDefinition:FlowDefinition example example
 * ```
 *
 */
public class FlowDefinition internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.FlowDefinition,
) : KotlinCustomResource(javaResource, FlowDefinitionMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Flow Definition.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of your flow definition.
     */
    public val flowDefinitionName: Output<String>
        get() = javaResource.flowDefinitionName().applyValue({ args0 -> args0 })

    /**
     * An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    public val humanLoopActivationConfig: Output<FlowDefinitionHumanLoopActivationConfig>?
        get() = javaResource.humanLoopActivationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    flowDefinitionHumanLoopActivationConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    public val humanLoopConfig: Output<FlowDefinitionHumanLoopConfig>
        get() = javaResource.humanLoopConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                flowDefinitionHumanLoopConfigToKotlin(args0)
            })
        })

    /**
     * Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    public val humanLoopRequestSource: Output<FlowDefinitionHumanLoopRequestSource>?
        get() = javaResource.humanLoopRequestSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> flowDefinitionHumanLoopRequestSourceToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    public val outputConfig: Output<FlowDefinitionOutputConfig>
        get() = javaResource.outputConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                flowDefinitionOutputConfigToKotlin(args0)
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FlowDefinitionMapper : ResourceMapper<FlowDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.FlowDefinition::class == javaResource::class

    override fun map(javaResource: Resource): FlowDefinition = FlowDefinition(
        javaResource as
            com.pulumi.aws.sagemaker.FlowDefinition,
    )
}

/**
 * @see [FlowDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FlowDefinition].
 */
public suspend fun flowDefinition(
    name: String,
    block: suspend FlowDefinitionResourceBuilder.() -> Unit,
): FlowDefinition {
    val builder = FlowDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FlowDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flowDefinition(name: String): FlowDefinition {
    val builder = FlowDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
