@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.FlowDefinitionArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopActivationConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopActivationConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopRequestSourceArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopRequestSourceArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionOutputConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionOutputConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Flow Definition resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(aws_sagemaker_human_task_ui.example().arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(aws_sagemaker_workteam.example().arn())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Public Workteam Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(aws_sagemaker_human_task_ui.example().arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(String.format("arn:aws:sagemaker:%s:394669845002:workteam/public-crowd/default", data.aws_region().current().name()))
 *                 .publicWorkforceTaskPrice(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs.builder()
 *                     .amountInUsd(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs.builder()
 *                         .cents(1)
 *                         .tenthFractionsOfACent(2)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Human Loop Activation Config Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(aws_sagemaker_human_task_ui.example().arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(aws_sagemaker_workteam.example().arn())
 *                 .build())
 *             .humanLoopRequestSource(FlowDefinitionHumanLoopRequestSourceArgs.builder()
 *                 .awsManagedHumanLoopRequestSource("AWS/Textract/AnalyzeDocument/Forms/V1")
 *                 .build())
 *             .humanLoopActivationConfig(FlowDefinitionHumanLoopActivationConfigArgs.builder()
 *                 .humanLoopActivationConditionsConfig(FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs.builder()
 *                     .humanLoopActivationConditions("""
 *         {
 * 			"Conditions": [
 * 			  {
 * 				"ConditionType": "Sampling",
 * 				"ConditionParameters": {
 * 				  "RandomSamplingPercentage": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 *                     """)
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Flow Definitions using the `flow_definition_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/flowDefinition:FlowDefinition example example
 * ```
 * @property flowDefinitionName The name of your flow definition.
 * @property humanLoopActivationConfig An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
 * @property humanLoopConfig An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
 * @property humanLoopRequestSource Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
 * @property outputConfig An object containing information about where the human review results will be uploaded. See Output Config details below.
 * @property roleArn The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FlowDefinitionArgs(
    public val flowDefinitionName: Output<String>? = null,
    public val humanLoopActivationConfig: Output<FlowDefinitionHumanLoopActivationConfigArgs>? = null,
    public val humanLoopConfig: Output<FlowDefinitionHumanLoopConfigArgs>? = null,
    public val humanLoopRequestSource: Output<FlowDefinitionHumanLoopRequestSourceArgs>? = null,
    public val outputConfig: Output<FlowDefinitionOutputConfigArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.FlowDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.FlowDefinitionArgs =
        com.pulumi.aws.sagemaker.FlowDefinitionArgs.builder()
            .flowDefinitionName(flowDefinitionName?.applyValue({ args0 -> args0 }))
            .humanLoopActivationConfig(
                humanLoopActivationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .humanLoopConfig(humanLoopConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .humanLoopRequestSource(
                humanLoopRequestSource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputConfig(outputConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FlowDefinitionArgs].
 */
@PulumiTagMarker
public class FlowDefinitionArgsBuilder internal constructor() {
    private var flowDefinitionName: Output<String>? = null

    private var humanLoopActivationConfig: Output<FlowDefinitionHumanLoopActivationConfigArgs>? = null

    private var humanLoopConfig: Output<FlowDefinitionHumanLoopConfigArgs>? = null

    private var humanLoopRequestSource: Output<FlowDefinitionHumanLoopRequestSourceArgs>? = null

    private var outputConfig: Output<FlowDefinitionOutputConfigArgs>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of your flow definition.
     */
    @JvmName("isphkxvbtkogknnd")
    public suspend fun flowDefinitionName(`value`: Output<String>) {
        this.flowDefinitionName = value
    }

    /**
     * @param value An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    @JvmName("tbfchyvlrgnxehxy")
    public suspend
    fun humanLoopActivationConfig(`value`: Output<FlowDefinitionHumanLoopActivationConfigArgs>) {
        this.humanLoopActivationConfig = value
    }

    /**
     * @param value An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    @JvmName("guppqmcpqvsooays")
    public suspend fun humanLoopConfig(`value`: Output<FlowDefinitionHumanLoopConfigArgs>) {
        this.humanLoopConfig = value
    }

    /**
     * @param value Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    @JvmName("nnvxihtdovihvqhj")
    public suspend
    fun humanLoopRequestSource(`value`: Output<FlowDefinitionHumanLoopRequestSourceArgs>) {
        this.humanLoopRequestSource = value
    }

    /**
     * @param value An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    @JvmName("tsyoivasisryanii")
    public suspend fun outputConfig(`value`: Output<FlowDefinitionOutputConfigArgs>) {
        this.outputConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
     */
    @JvmName("bnvrfakkvpnvminn")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sjqrycyyhdqhenma")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of your flow definition.
     */
    @JvmName("maktpgthjlakjwhl")
    public suspend fun flowDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowDefinitionName = mapped
    }

    /**
     * @param value An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    @JvmName("kgjbsonfxhfchscn")
    public suspend
    fun humanLoopActivationConfig(`value`: FlowDefinitionHumanLoopActivationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanLoopActivationConfig = mapped
    }

    /**
     * @param argument An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    @JvmName("kqunvldwykssspca")
    public suspend
    fun humanLoopActivationConfig(argument: suspend FlowDefinitionHumanLoopActivationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionHumanLoopActivationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.humanLoopActivationConfig = mapped
    }

    /**
     * @param value An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    @JvmName("rswkhpgawmiygoay")
    public suspend fun humanLoopConfig(`value`: FlowDefinitionHumanLoopConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanLoopConfig = mapped
    }

    /**
     * @param argument An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    @JvmName("jqgidpkfckbpifwi")
    public suspend
    fun humanLoopConfig(argument: suspend FlowDefinitionHumanLoopConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionHumanLoopConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.humanLoopConfig = mapped
    }

    /**
     * @param value Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    @JvmName("damscveurverrulx")
    public suspend fun humanLoopRequestSource(`value`: FlowDefinitionHumanLoopRequestSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanLoopRequestSource = mapped
    }

    /**
     * @param argument Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    @JvmName("uyjserffxeqnwsgx")
    public suspend
    fun humanLoopRequestSource(argument: suspend FlowDefinitionHumanLoopRequestSourceArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionHumanLoopRequestSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.humanLoopRequestSource = mapped
    }

    /**
     * @param value An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    @JvmName("fjfppmhgjqgikhot")
    public suspend fun outputConfig(`value`: FlowDefinitionOutputConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputConfig = mapped
    }

    /**
     * @param argument An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    @JvmName("bxoqjonmemyckqxv")
    public suspend
    fun outputConfig(argument: suspend FlowDefinitionOutputConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionOutputConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputConfig = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
     */
    @JvmName("fjffwbqpbwokvmkt")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nwaubekshobjmylt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mkddpflvviyfdavd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FlowDefinitionArgs = FlowDefinitionArgs(
        flowDefinitionName = flowDefinitionName,
        humanLoopActivationConfig = humanLoopActivationConfig,
        humanLoopConfig = humanLoopConfig,
        humanLoopRequestSource = humanLoopRequestSource,
        outputConfig = outputConfig,
        roleArn = roleArn,
        tags = tags,
    )
}
