@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.HumanTaskUIArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.HumanTaskUIUiTemplateArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.HumanTaskUIUiTemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Human Task UI resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.HumanTaskUI;
 * import com.pulumi.aws.sagemaker.HumanTaskUIArgs;
 * import com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HumanTaskUI("example", HumanTaskUIArgs.builder()
 *             .humanTaskUiName("example")
 *             .uiTemplate(HumanTaskUIUiTemplateArgs.builder()
 *                 .content(Files.readString(Paths.get("sagemaker-human-task-ui-template.html")))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Human Task UIs using the `human_task_ui_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/humanTaskUI:HumanTaskUI example example
 * ```
 * @property humanTaskUiName The name of the Human Task UI.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property uiTemplate The Liquid template for the worker user interface. See UI Template below.
 */
public data class HumanTaskUIArgs(
    public val humanTaskUiName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uiTemplate: Output<HumanTaskUIUiTemplateArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.HumanTaskUIArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.HumanTaskUIArgs =
        com.pulumi.aws.sagemaker.HumanTaskUIArgs.builder()
            .humanTaskUiName(humanTaskUiName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uiTemplate(uiTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HumanTaskUIArgs].
 */
@PulumiTagMarker
public class HumanTaskUIArgsBuilder internal constructor() {
    private var humanTaskUiName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uiTemplate: Output<HumanTaskUIUiTemplateArgs>? = null

    /**
     * @param value The name of the Human Task UI.
     */
    @JvmName("ukxvjxwmikliswyj")
    public suspend fun humanTaskUiName(`value`: Output<String>) {
        this.humanTaskUiName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iidcuhenibnkwweg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Liquid template for the worker user interface. See UI Template below.
     */
    @JvmName("jpfhrjkrfyfgivxi")
    public suspend fun uiTemplate(`value`: Output<HumanTaskUIUiTemplateArgs>) {
        this.uiTemplate = value
    }

    /**
     * @param value The name of the Human Task UI.
     */
    @JvmName("iwxlfkycgwgpysww")
    public suspend fun humanTaskUiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanTaskUiName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qipbrpcawxghxill")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aaoygpvquusutepk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Liquid template for the worker user interface. See UI Template below.
     */
    @JvmName("icedmkudjgwhcgun")
    public suspend fun uiTemplate(`value`: HumanTaskUIUiTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uiTemplate = mapped
    }

    /**
     * @param argument The Liquid template for the worker user interface. See UI Template below.
     */
    @JvmName("antlehjyurppidgv")
    public suspend fun uiTemplate(argument: suspend HumanTaskUIUiTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = HumanTaskUIUiTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.uiTemplate = mapped
    }

    internal fun build(): HumanTaskUIArgs = HumanTaskUIArgs(
        humanTaskUiName = humanTaskUiName,
        tags = tags,
        uiTemplate = uiTemplate,
    )
}
