@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ImageVersion].
 */
@PulumiTagMarker
public class ImageVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageVersionArgs = ImageVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageVersionArgsBuilder.() -> Unit) {
        val builder = ImageVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ImageVersion {
        val builtJavaResource = com.pulumi.aws.sagemaker.ImageVersion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImageVersion(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Image Version resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.ImageVersion;
 * import com.pulumi.aws.sagemaker.ImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ImageVersion("test", ImageVersionArgs.builder()
 *             .imageName(aws_sagemaker_image.test().id())
 *             .baseImage("012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Image Versions using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/imageVersion:ImageVersion test_image my-code-repo
 * ```
 *
 */
public class ImageVersion internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.ImageVersion,
) : KotlinCustomResource(javaResource, ImageVersionMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Image Version.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The registry path of the container image on which this image version is based.
     */
    public val baseImage: Output<String>
        get() = javaResource.baseImage().applyValue({ args0 -> args0 })

    /**
     * The registry path of the container image that contains this image version.
     */
    public val containerImage: Output<String>
        get() = javaResource.containerImage().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the image the version is based on.
     */
    public val imageArn: Output<String>
        get() = javaResource.imageArn().applyValue({ args0 -> args0 })

    /**
     * The name of the image. Must be unique to your account.
     */
    public val imageName: Output<String>
        get() = javaResource.imageName().applyValue({ args0 -> args0 })

    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ImageVersionMapper : ResourceMapper<ImageVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.ImageVersion::class == javaResource::class

    override fun map(javaResource: Resource): ImageVersion = ImageVersion(
        javaResource as
            com.pulumi.aws.sagemaker.ImageVersion,
    )
}

/**
 * @see [ImageVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImageVersion].
 */
public suspend fun imageVersion(
    name: String,
    block: suspend ImageVersionResourceBuilder.() -> Unit,
): ImageVersion {
    val builder = ImageVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImageVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imageVersion(name: String): ImageVersion {
    val builder = ImageVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
