@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.ModelContainer
import com.pulumi.aws.sagemaker.kotlin.outputs.ModelInferenceExecutionConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.ModelPrimaryContainer
import com.pulumi.aws.sagemaker.kotlin.outputs.ModelVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.ModelContainer.Companion.toKotlin as modelContainerToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.ModelInferenceExecutionConfig.Companion.toKotlin as modelInferenceExecutionConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.ModelPrimaryContainer.Companion.toKotlin as modelPrimaryContainerToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.ModelVpcConfig.Companion.toKotlin as modelVpcConfigToKotlin

/**
 * Builder for [Model].
 */
@PulumiTagMarker
public class ModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelArgs = ModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelArgsBuilder.() -> Unit) {
        val builder = ModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Model {
        val builtJavaResource = com.pulumi.aws.sagemaker.Model(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Model(builtJavaResource)
    }
}

/**
 * Provides a SageMaker model resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sagemaker.SagemakerFunctions;
 * import com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImageArgs;
 * import com.pulumi.aws.sagemaker.Model;
 * import com.pulumi.aws.sagemaker.ModelArgs;
 * import com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("sagemaker.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var test = SagemakerFunctions.getPrebuiltEcrImage(GetPrebuiltEcrImageArgs.builder()
 *             .repositoryName("kmeans")
 *             .build());
 *         var exampleModel = new Model("exampleModel", ModelArgs.builder()
 *             .executionRoleArn(exampleRole.arn())
 *             .primaryContainer(ModelPrimaryContainerArgs.builder()
 *                 .image(test.applyValue(getPrebuiltEcrImageResult -> getPrebuiltEcrImageResult.registryPath()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Inference Execution Config
 * * `mode` - (Required) How containers in a multi-container are run. The following values are valid `Serial` and `Direct`.
 * ## Import
 * Using `pulumi import`, import models using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/model:Model test_model model-foo
 * ```
 *
 */
public class Model internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Model,
) : KotlinCustomResource(javaResource, ModelMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this model.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    public val containers: Output<List<ModelContainer>>?
        get() = javaResource.containers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> modelContainerToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     */
    public val enableNetworkIsolation: Output<Boolean>?
        get() = javaResource.enableNetworkIsolation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A role that SageMaker can assume to access model artifacts and docker images for deployment.
     */
    public val executionRoleArn: Output<String>
        get() = javaResource.executionRoleArn().applyValue({ args0 -> args0 })

    /**
     * Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
     */
    public val inferenceExecutionConfig: Output<ModelInferenceExecutionConfig>
        get() = javaResource.inferenceExecutionConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                modelInferenceExecutionConfigToKotlin(args0)
            })
        })

    /**
     * The name of the model (must be unique). If omitted, this provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
     */
    public val primaryContainer: Output<ModelPrimaryContainer>?
        get() = javaResource.primaryContainer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> modelPrimaryContainerToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The `primary_container` and `container` block both support:
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
     */
    public val vpcConfig: Output<ModelVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    modelVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ModelMapper : ResourceMapper<Model> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Model::class == javaResource::class

    override fun map(javaResource: Resource): Model = Model(
        javaResource as
            com.pulumi.aws.sagemaker.Model,
    )
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Model].
 */
public suspend fun model(name: String, block: suspend ModelResourceBuilder.() -> Unit): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 */
public fun model(name: String): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
