@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ModelArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelContainerArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelContainerArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelInferenceExecutionConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelInferenceExecutionConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelPrimaryContainerArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelPrimaryContainerArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelVpcConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker model resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sagemaker.SagemakerFunctions;
 * import com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImageArgs;
 * import com.pulumi.aws.sagemaker.Model;
 * import com.pulumi.aws.sagemaker.ModelArgs;
 * import com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("sagemaker.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var test = SagemakerFunctions.getPrebuiltEcrImage(GetPrebuiltEcrImageArgs.builder()
 *             .repositoryName("kmeans")
 *             .build());
 *         var exampleModel = new Model("exampleModel", ModelArgs.builder()
 *             .executionRoleArn(exampleRole.arn())
 *             .primaryContainer(ModelPrimaryContainerArgs.builder()
 *                 .image(test.applyValue(getPrebuiltEcrImageResult -> getPrebuiltEcrImageResult.registryPath()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Inference Execution Config
 * * `mode` - (Required) How containers in a multi-container are run. The following values are valid `Serial` and `Direct`.
 * ## Import
 * Using `pulumi import`, import models using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/model:Model test_model model-foo
 * ```
 * @property containers Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
 * @property enableNetworkIsolation Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
 * @property executionRoleArn A role that SageMaker can assume to access model artifacts and docker images for deployment.
 * @property inferenceExecutionConfig Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
 * @property name The name of the model (must be unique). If omitted, this provider will assign a random, unique name.
 * @property primaryContainer The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * The `primary_container` and `container` block both support:
 * @property vpcConfig Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
 */
public data class ModelArgs(
    public val containers: Output<List<ModelContainerArgs>>? = null,
    public val enableNetworkIsolation: Output<Boolean>? = null,
    public val executionRoleArn: Output<String>? = null,
    public val inferenceExecutionConfig: Output<ModelInferenceExecutionConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val primaryContainer: Output<ModelPrimaryContainerArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<ModelVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ModelArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ModelArgs =
        com.pulumi.aws.sagemaker.ModelArgs.builder()
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableNetworkIsolation(enableNetworkIsolation?.applyValue({ args0 -> args0 }))
            .executionRoleArn(executionRoleArn?.applyValue({ args0 -> args0 }))
            .inferenceExecutionConfig(
                inferenceExecutionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .primaryContainer(primaryContainer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ModelArgs].
 */
@PulumiTagMarker
public class ModelArgsBuilder internal constructor() {
    private var containers: Output<List<ModelContainerArgs>>? = null

    private var enableNetworkIsolation: Output<Boolean>? = null

    private var executionRoleArn: Output<String>? = null

    private var inferenceExecutionConfig: Output<ModelInferenceExecutionConfigArgs>? = null

    private var name: Output<String>? = null

    private var primaryContainer: Output<ModelPrimaryContainerArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<ModelVpcConfigArgs>? = null

    /**
     * @param value Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("hmasjdojknqkgqvl")
    public suspend fun containers(`value`: Output<List<ModelContainerArgs>>) {
        this.containers = value
    }

    @JvmName("gaapdbeddmeaqrmh")
    public suspend fun containers(vararg values: Output<ModelContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("hdmcdhwhmyoghfuo")
    public suspend fun containers(values: List<Output<ModelContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     */
    @JvmName("kbwddvdvagobudgs")
    public suspend fun enableNetworkIsolation(`value`: Output<Boolean>) {
        this.enableNetworkIsolation = value
    }

    /**
     * @param value A role that SageMaker can assume to access model artifacts and docker images for deployment.
     */
    @JvmName("xpugoqlyuqjrornv")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
     */
    @JvmName("iktejtwfaqnjuofk")
    public suspend fun inferenceExecutionConfig(`value`: Output<ModelInferenceExecutionConfigArgs>) {
        this.inferenceExecutionConfig = value
    }

    /**
     * @param value The name of the model (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("bawlndhlajkecsqd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
     */
    @JvmName("cvpbbbqaavqnqroc")
    public suspend fun primaryContainer(`value`: Output<ModelPrimaryContainerArgs>) {
        this.primaryContainer = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The `primary_container` and `container` block both support:
     */
    @JvmName("rvtxqvqshktujyag")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
     */
    @JvmName("bihdjdrdtbjldurj")
    public suspend fun vpcConfig(`value`: Output<ModelVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("ptllqycclpvofffl")
    public suspend fun containers(`value`: List<ModelContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("kscdrxruedgctiet")
    public suspend fun containers(argument: List<suspend ModelContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ModelContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("ibinodjdypnqydsl")
    public suspend fun containers(vararg argument: suspend ModelContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ModelContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("hqvbgjewbjgogram")
    public suspend fun containers(argument: suspend ModelContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ModelContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("sernsctsfcuyctfw")
    public suspend fun containers(vararg values: ModelContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     */
    @JvmName("qfrjfbajmklpwpgg")
    public suspend fun enableNetworkIsolation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNetworkIsolation = mapped
    }

    /**
     * @param value A role that SageMaker can assume to access model artifacts and docker images for deployment.
     */
    @JvmName("xkbysvvgrkrfskcr")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
     */
    @JvmName("gbqrfkedaiuotnnj")
    public suspend fun inferenceExecutionConfig(`value`: ModelInferenceExecutionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceExecutionConfig = mapped
    }

    /**
     * @param argument Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
     */
    @JvmName("wxwufhfafpvdemxh")
    public suspend
    fun inferenceExecutionConfig(argument: suspend ModelInferenceExecutionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ModelInferenceExecutionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inferenceExecutionConfig = mapped
    }

    /**
     * @param value The name of the model (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("grgbgalrvoraouwd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
     */
    @JvmName("iqrhwkscaadrgkfs")
    public suspend fun primaryContainer(`value`: ModelPrimaryContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryContainer = mapped
    }

    /**
     * @param argument The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
     */
    @JvmName("euerjilggshpkpqp")
    public suspend
    fun primaryContainer(argument: suspend ModelPrimaryContainerArgsBuilder.() -> Unit) {
        val toBeMapped = ModelPrimaryContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryContainer = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The `primary_container` and `container` block both support:
     */
    @JvmName("txltbqxnboatfwaf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * The `primary_container` and `container` block both support:
     */
    @JvmName("allxctbewadlsjcc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
     */
    @JvmName("gisyqlknrloelolj")
    public suspend fun vpcConfig(`value`: ModelVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
     */
    @JvmName("botjbkbptrctfskn")
    public suspend fun vpcConfig(argument: suspend ModelVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ModelVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): ModelArgs = ModelArgs(
        containers = containers,
        enableNetworkIsolation = enableNetworkIsolation,
        executionRoleArn = executionRoleArn,
        inferenceExecutionConfig = inferenceExecutionConfig,
        name = name,
        primaryContainer = primaryContainer,
        tags = tags,
        vpcConfig = vpcConfig,
    )
}
