@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ModelPackageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Model Package Group resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.ModelPackageGroup;
 * import com.pulumi.aws.sagemaker.ModelPackageGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ModelPackageGroup("example", ModelPackageGroupArgs.builder()
 *             .modelPackageGroupName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Model Package Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/modelPackageGroup:ModelPackageGroup test_model_package_group my-code-repo
 * ```
 * @property modelPackageGroupDescription A description for the model group.
 * @property modelPackageGroupName The name of the model group.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ModelPackageGroupArgs(
    public val modelPackageGroupDescription: Output<String>? = null,
    public val modelPackageGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ModelPackageGroupArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ModelPackageGroupArgs =
        com.pulumi.aws.sagemaker.ModelPackageGroupArgs.builder()
            .modelPackageGroupDescription(modelPackageGroupDescription?.applyValue({ args0 -> args0 }))
            .modelPackageGroupName(modelPackageGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ModelPackageGroupArgs].
 */
@PulumiTagMarker
public class ModelPackageGroupArgsBuilder internal constructor() {
    private var modelPackageGroupDescription: Output<String>? = null

    private var modelPackageGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description for the model group.
     */
    @JvmName("mekgrncowyhgjvfa")
    public suspend fun modelPackageGroupDescription(`value`: Output<String>) {
        this.modelPackageGroupDescription = value
    }

    /**
     * @param value The name of the model group.
     */
    @JvmName("mocrvirbraawvpws")
    public suspend fun modelPackageGroupName(`value`: Output<String>) {
        this.modelPackageGroupName = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qoejrsmvqastuodp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description for the model group.
     */
    @JvmName("svwueqowsrxeeilg")
    public suspend fun modelPackageGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelPackageGroupDescription = mapped
    }

    /**
     * @param value The name of the model group.
     */
    @JvmName("iyuckdxtqqysojxf")
    public suspend fun modelPackageGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelPackageGroupName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xuofxbfgpryuwvvm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aosspwrcbxueiyjs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ModelPackageGroupArgs = ModelPackageGroupArgs(
        modelPackageGroupDescription = modelPackageGroupDescription,
        modelPackageGroupName = modelPackageGroupName,
        tags = tags,
    )
}
