@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ModelPackageGroupPolicy].
 */
@PulumiTagMarker
public class ModelPackageGroupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelPackageGroupPolicyArgs = ModelPackageGroupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelPackageGroupPolicyArgsBuilder.() -> Unit) {
        val builder = ModelPackageGroupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ModelPackageGroupPolicy {
        val builtJavaResource =
            com.pulumi.aws.sagemaker.ModelPackageGroupPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ModelPackageGroupPolicy(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Model Package Group Policy resource.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import SageMaker Model Package Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/modelPackageGroupPolicy:ModelPackageGroupPolicy example example
 * ```
 *
 */
public class ModelPackageGroupPolicy internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.ModelPackageGroupPolicy,
) : KotlinCustomResource(javaResource, ModelPackageGroupPolicyMapper) {
    /**
     * The name of the model package group.
     */
    public val modelPackageGroupName: Output<String>
        get() = javaResource.modelPackageGroupName().applyValue({ args0 -> args0 })

    public val resourcePolicy: Output<String>
        get() = javaResource.resourcePolicy().applyValue({ args0 -> args0 })
}

public object ModelPackageGroupPolicyMapper : ResourceMapper<ModelPackageGroupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.ModelPackageGroupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ModelPackageGroupPolicy =
        ModelPackageGroupPolicy(javaResource as com.pulumi.aws.sagemaker.ModelPackageGroupPolicy)
}

/**
 * @see [ModelPackageGroupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ModelPackageGroupPolicy].
 */
public suspend fun modelPackageGroupPolicy(
    name: String,
    block: suspend ModelPackageGroupPolicyResourceBuilder.() -> Unit,
): ModelPackageGroupPolicy {
    val builder = ModelPackageGroupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ModelPackageGroupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun modelPackageGroupPolicy(name: String): ModelPackageGroupPolicy {
    val builder = ModelPackageGroupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
