@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ModelPackageGroupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Model Package Group Policy resource.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import SageMaker Model Package Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/modelPackageGroupPolicy:ModelPackageGroupPolicy example example
 * ```
 * @property modelPackageGroupName The name of the model package group.
 * @property resourcePolicy
 */
public data class ModelPackageGroupPolicyArgs(
    public val modelPackageGroupName: Output<String>? = null,
    public val resourcePolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ModelPackageGroupPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ModelPackageGroupPolicyArgs =
        com.pulumi.aws.sagemaker.ModelPackageGroupPolicyArgs.builder()
            .modelPackageGroupName(modelPackageGroupName?.applyValue({ args0 -> args0 }))
            .resourcePolicy(resourcePolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelPackageGroupPolicyArgs].
 */
@PulumiTagMarker
public class ModelPackageGroupPolicyArgsBuilder internal constructor() {
    private var modelPackageGroupName: Output<String>? = null

    private var resourcePolicy: Output<String>? = null

    /**
     * @param value The name of the model package group.
     */
    @JvmName("bvxyojapdlkqfnhb")
    public suspend fun modelPackageGroupName(`value`: Output<String>) {
        this.modelPackageGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("sgiyxuqdmjytaowe")
    public suspend fun resourcePolicy(`value`: Output<String>) {
        this.resourcePolicy = value
    }

    /**
     * @param value The name of the model package group.
     */
    @JvmName("bmpjphlecvrkkits")
    public suspend fun modelPackageGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelPackageGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("gekwknivkhaoixvb")
    public suspend fun resourcePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePolicy = mapped
    }

    internal fun build(): ModelPackageGroupPolicyArgs = ModelPackageGroupPolicyArgs(
        modelPackageGroupName = modelPackageGroupName,
        resourcePolicy = resourcePolicy,
    )
}
