@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.MonitoringScheduleArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.MonitoringScheduleMonitoringScheduleConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.MonitoringScheduleMonitoringScheduleConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker monitoring schedule resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.MonitoringSchedule;
 * import com.pulumi.aws.sagemaker.MonitoringScheduleArgs;
 * import com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new MonitoringSchedule("test", MonitoringScheduleArgs.builder()
 *             .monitoringScheduleConfig(MonitoringScheduleMonitoringScheduleConfigArgs.builder()
 *                 .monitoringJobDefinitionName(aws_sagemaker_data_quality_job_definition.test().name())
 *                 .monitoringType("DataQuality")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import monitoring schedules using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/monitoringSchedule:MonitoringSchedule test_monitoring_schedule monitoring-schedule-foo
 * ```
 * @property monitoringScheduleConfig The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
 * @property name The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MonitoringScheduleArgs(
    public val monitoringScheduleConfig: Output<MonitoringScheduleMonitoringScheduleConfigArgs>? =
        null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.MonitoringScheduleArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.MonitoringScheduleArgs =
        com.pulumi.aws.sagemaker.MonitoringScheduleArgs.builder()
            .monitoringScheduleConfig(
                monitoringScheduleConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MonitoringScheduleArgs].
 */
@PulumiTagMarker
public class MonitoringScheduleArgsBuilder internal constructor() {
    private var monitoringScheduleConfig: Output<MonitoringScheduleMonitoringScheduleConfigArgs>? =
        null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     */
    @JvmName("yfnlvpitscrwutyi")
    public suspend
    fun monitoringScheduleConfig(`value`: Output<MonitoringScheduleMonitoringScheduleConfigArgs>) {
        this.monitoringScheduleConfig = value
    }

    /**
     * @param value The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("lskgdpnpoaslihlc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fhqrwrndxpymnhvl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     */
    @JvmName("iryhbqonoelebcny")
    public suspend
    fun monitoringScheduleConfig(`value`: MonitoringScheduleMonitoringScheduleConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringScheduleConfig = mapped
    }

    /**
     * @param argument The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     */
    @JvmName("lxoyxybiaoslyovt")
    public suspend
    fun monitoringScheduleConfig(argument: suspend MonitoringScheduleMonitoringScheduleConfigArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringScheduleMonitoringScheduleConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.monitoringScheduleConfig = mapped
    }

    /**
     * @param value The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("sppjsyivpolwsyha")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iijtbcqgfsfgiyiv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kaewtwkosxuvaydt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MonitoringScheduleArgs = MonitoringScheduleArgs(
        monitoringScheduleConfig = monitoringScheduleConfig,
        name = name,
        tags = tags,
    )
}
