@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.NotebookInstanceArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.NotebookInstanceInstanceMetadataServiceConfigurationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.NotebookInstanceInstanceMetadataServiceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Notebook Instance resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.NotebookInstance;
 * import com.pulumi.aws.sagemaker.NotebookInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ni = new NotebookInstance("ni", NotebookInstanceArgs.builder()
 *             .roleArn(aws_iam_role.role().arn())
 *             .instanceType("ml.t2.medium")
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ### Code repository usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import com.pulumi.aws.sagemaker.NotebookInstance;
 * import com.pulumi.aws.sagemaker.NotebookInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CodeRepository("example", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("my-notebook-instance-code-repo")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .build())
 *             .build());
 *         var ni = new NotebookInstance("ni", NotebookInstanceArgs.builder()
 *             .roleArn(aws_iam_role.role().arn())
 *             .instanceType("ml.t2.medium")
 *             .defaultCodeRepository(example.codeRepositoryName())
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Notebook Instances using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/notebookInstance:NotebookInstance test_notebook_instance my-notebook-instance
 * ```
 * @property acceleratorTypes A list of Elastic Inference (EI) instance types to associate with this notebook instance. See [Elastic Inference Accelerator](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html) for more details. Valid values: `ml.eia1.medium`, `ml.eia1.large`, `ml.eia1.xlarge`, `ml.eia2.medium`, `ml.eia2.large`, `ml.eia2.xlarge`.
 * @property additionalCodeRepositories An array of up to three Git repositories to associate with the notebook instance.
 * These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance.
 * @property defaultCodeRepository The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
 * @property directInternetAccess Set to `Disabled` to disable internet access to notebook. Requires `security_groups` and `subnet_id` to be set. Supported values: `Enabled` (Default) or `Disabled`. If set to `Disabled`, the notebook instance will be able to access resources only in your VPC, and will not be able to connect to Amazon SageMaker training and endpoint services unless your configure a NAT Gateway in your VPC.
 * @property instanceMetadataServiceConfiguration Information on the IMDS configuration of the notebook instance. Conflicts with `instance_metadata_service_configuration`. see details below.
 * @property instanceType The name of ML compute instance type.
 * @property kmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
 * @property lifecycleConfigName The name of a lifecycle configuration to associate with the notebook instance.
 * @property name The name of the notebook instance (must be unique).
 * @property platformIdentifier The platform identifier of the notebook instance runtime environment. This value can be either `notebook-al1-v1`, `notebook-al2-v1`, or  `notebook-al2-v2`, depending on which version of Amazon Linux you require.
 * @property roleArn The ARN of the IAM role to be used by the notebook instance which allows SageMaker to call other services on your behalf.
 * @property rootAccess Whether root access is `Enabled` or `Disabled` for users of the notebook instance. The default value is `Enabled`.
 * @property securityGroups The associated security groups.
 * @property subnetId The VPC subnet ID.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property volumeSize The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
 */
public data class NotebookInstanceArgs(
    public val acceleratorTypes: Output<List<String>>? = null,
    public val additionalCodeRepositories: Output<List<String>>? = null,
    public val defaultCodeRepository: Output<String>? = null,
    public val directInternetAccess: Output<String>? = null,
    public val instanceMetadataServiceConfiguration:
    Output<NotebookInstanceInstanceMetadataServiceConfigurationArgs>? = null,
    public val instanceType: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val lifecycleConfigName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val platformIdentifier: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val rootAccess: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumeSize: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.NotebookInstanceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.NotebookInstanceArgs =
        com.pulumi.aws.sagemaker.NotebookInstanceArgs.builder()
            .acceleratorTypes(acceleratorTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .additionalCodeRepositories(
                additionalCodeRepositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .defaultCodeRepository(defaultCodeRepository?.applyValue({ args0 -> args0 }))
            .directInternetAccess(directInternetAccess?.applyValue({ args0 -> args0 }))
            .instanceMetadataServiceConfiguration(
                instanceMetadataServiceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .lifecycleConfigName(lifecycleConfigName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .platformIdentifier(platformIdentifier?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .rootAccess(rootAccess?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotebookInstanceArgs].
 */
@PulumiTagMarker
public class NotebookInstanceArgsBuilder internal constructor() {
    private var acceleratorTypes: Output<List<String>>? = null

    private var additionalCodeRepositories: Output<List<String>>? = null

    private var defaultCodeRepository: Output<String>? = null

    private var directInternetAccess: Output<String>? = null

    private var instanceMetadataServiceConfiguration:
        Output<NotebookInstanceInstanceMetadataServiceConfigurationArgs>? = null

    private var instanceType: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var lifecycleConfigName: Output<String>? = null

    private var name: Output<String>? = null

    private var platformIdentifier: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var rootAccess: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumeSize: Output<Int>? = null

    /**
     * @param value A list of Elastic Inference (EI) instance types to associate with this notebook instance. See [Elastic Inference Accelerator](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html) for more details. Valid values: `ml.eia1.medium`, `ml.eia1.large`, `ml.eia1.xlarge`, `ml.eia2.medium`, `ml.eia2.large`, `ml.eia2.xlarge`.
     */
    @JvmName("mkildsxarkpmfkcs")
    public suspend fun acceleratorTypes(`value`: Output<List<String>>) {
        this.acceleratorTypes = value
    }

    @JvmName("qhqchogjcwflaxrs")
    public suspend fun acceleratorTypes(vararg values: Output<String>) {
        this.acceleratorTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of Elastic Inference (EI) instance types to associate with this notebook instance. See [Elastic Inference Accelerator](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html) for more details. Valid values: `ml.eia1.medium`, `ml.eia1.large`, `ml.eia1.xlarge`, `ml.eia2.medium`, `ml.eia2.large`, `ml.eia2.xlarge`.
     */
    @JvmName("ekgtlhlwsqfoaqfx")
    public suspend fun acceleratorTypes(values: List<Output<String>>) {
        this.acceleratorTypes = Output.all(values)
    }

    /**
     * @param value An array of up to three Git repositories to associate with the notebook instance.
     * These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance.
     */
    @JvmName("fvcmnscnxhwrfibm")
    public suspend fun additionalCodeRepositories(`value`: Output<List<String>>) {
        this.additionalCodeRepositories = value
    }

    @JvmName("pkmykjkixxihrifx")
    public suspend fun additionalCodeRepositories(vararg values: Output<String>) {
        this.additionalCodeRepositories = Output.all(values.asList())
    }

    /**
     * @param values An array of up to three Git repositories to associate with the notebook instance.
     * These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance.
     */
    @JvmName("ajklhhhlkrmrsxpj")
    public suspend fun additionalCodeRepositories(values: List<Output<String>>) {
        this.additionalCodeRepositories = Output.all(values)
    }

    /**
     * @param value The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
     */
    @JvmName("rhyabweorkomucct")
    public suspend fun defaultCodeRepository(`value`: Output<String>) {
        this.defaultCodeRepository = value
    }

    /**
     * @param value Set to `Disabled` to disable internet access to notebook. Requires `security_groups` and `subnet_id` to be set. Supported values: `Enabled` (Default) or `Disabled`. If set to `Disabled`, the notebook instance will be able to access resources only in your VPC, and will not be able to connect to Amazon SageMaker training and endpoint services unless your configure a NAT Gateway in your VPC.
     */
    @JvmName("ckxcswpvutbfwooi")
    public suspend fun directInternetAccess(`value`: Output<String>) {
        this.directInternetAccess = value
    }

    /**
     * @param value Information on the IMDS configuration of the notebook instance. Conflicts with `instance_metadata_service_configuration`. see details below.
     */
    @JvmName("fexppwygkkahravv")
    public suspend
    fun instanceMetadataServiceConfiguration(`value`: Output<NotebookInstanceInstanceMetadataServiceConfigurationArgs>) {
        this.instanceMetadataServiceConfiguration = value
    }

    /**
     * @param value The name of ML compute instance type.
     */
    @JvmName("gyxpuvenbldbjksv")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    @JvmName("jxggpelluaytjmpu")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of a lifecycle configuration to associate with the notebook instance.
     */
    @JvmName("hloosotdepshtjvc")
    public suspend fun lifecycleConfigName(`value`: Output<String>) {
        this.lifecycleConfigName = value
    }

    /**
     * @param value The name of the notebook instance (must be unique).
     */
    @JvmName("jnwnnhsowwfasufp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The platform identifier of the notebook instance runtime environment. This value can be either `notebook-al1-v1`, `notebook-al2-v1`, or  `notebook-al2-v2`, depending on which version of Amazon Linux you require.
     */
    @JvmName("xvojhscydbfifnud")
    public suspend fun platformIdentifier(`value`: Output<String>) {
        this.platformIdentifier = value
    }

    /**
     * @param value The ARN of the IAM role to be used by the notebook instance which allows SageMaker to call other services on your behalf.
     */
    @JvmName("vahjykrjmxxufgpr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Whether root access is `Enabled` or `Disabled` for users of the notebook instance. The default value is `Enabled`.
     */
    @JvmName("msfdiiguscrcxpsx")
    public suspend fun rootAccess(`value`: Output<String>) {
        this.rootAccess = value
    }

    /**
     * @param value The associated security groups.
     */
    @JvmName("qdwuhaootimctgun")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("jycecdplqwycrjrj")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The associated security groups.
     */
    @JvmName("uqpynmrkgcdwoghb")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The VPC subnet ID.
     */
    @JvmName("wesawtswgiubctkd")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uxmewrcgulhbgdkg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     */
    @JvmName("dxdpwjgcrvxxqbad")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value A list of Elastic Inference (EI) instance types to associate with this notebook instance. See [Elastic Inference Accelerator](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html) for more details. Valid values: `ml.eia1.medium`, `ml.eia1.large`, `ml.eia1.xlarge`, `ml.eia2.medium`, `ml.eia2.large`, `ml.eia2.xlarge`.
     */
    @JvmName("yuhgxcbvmyvuujlh")
    public suspend fun acceleratorTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param values A list of Elastic Inference (EI) instance types to associate with this notebook instance. See [Elastic Inference Accelerator](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html) for more details. Valid values: `ml.eia1.medium`, `ml.eia1.large`, `ml.eia1.xlarge`, `ml.eia2.medium`, `ml.eia2.large`, `ml.eia2.xlarge`.
     */
    @JvmName("pymlmndvwuaqdwrp")
    public suspend fun acceleratorTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param value An array of up to three Git repositories to associate with the notebook instance.
     * These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance.
     */
    @JvmName("lweoooblljejudll")
    public suspend fun additionalCodeRepositories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCodeRepositories = mapped
    }

    /**
     * @param values An array of up to three Git repositories to associate with the notebook instance.
     * These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance.
     */
    @JvmName("owoeqlvnrxsonwxj")
    public suspend fun additionalCodeRepositories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalCodeRepositories = mapped
    }

    /**
     * @param value The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
     */
    @JvmName("lcdiysxktwbicduq")
    public suspend fun defaultCodeRepository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCodeRepository = mapped
    }

    /**
     * @param value Set to `Disabled` to disable internet access to notebook. Requires `security_groups` and `subnet_id` to be set. Supported values: `Enabled` (Default) or `Disabled`. If set to `Disabled`, the notebook instance will be able to access resources only in your VPC, and will not be able to connect to Amazon SageMaker training and endpoint services unless your configure a NAT Gateway in your VPC.
     */
    @JvmName("trcagldksdscfyop")
    public suspend fun directInternetAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directInternetAccess = mapped
    }

    /**
     * @param value Information on the IMDS configuration of the notebook instance. Conflicts with `instance_metadata_service_configuration`. see details below.
     */
    @JvmName("vjjocdovqfamfjtl")
    public suspend
    fun instanceMetadataServiceConfiguration(`value`: NotebookInstanceInstanceMetadataServiceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMetadataServiceConfiguration = mapped
    }

    /**
     * @param argument Information on the IMDS configuration of the notebook instance. Conflicts with `instance_metadata_service_configuration`. see details below.
     */
    @JvmName("nbqxxtutphnkbmvb")
    public suspend
    fun instanceMetadataServiceConfiguration(argument: suspend NotebookInstanceInstanceMetadataServiceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NotebookInstanceInstanceMetadataServiceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceMetadataServiceConfiguration = mapped
    }

    /**
     * @param value The name of ML compute instance type.
     */
    @JvmName("lmxfamjyjksqmudx")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    @JvmName("eyyljkbwsuegynjg")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of a lifecycle configuration to associate with the notebook instance.
     */
    @JvmName("egmfoyxofwrdohwx")
    public suspend fun lifecycleConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigName = mapped
    }

    /**
     * @param value The name of the notebook instance (must be unique).
     */
    @JvmName("rstkphuhglcpexru")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The platform identifier of the notebook instance runtime environment. This value can be either `notebook-al1-v1`, `notebook-al2-v1`, or  `notebook-al2-v2`, depending on which version of Amazon Linux you require.
     */
    @JvmName("polyhnrhruagexqr")
    public suspend fun platformIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformIdentifier = mapped
    }

    /**
     * @param value The ARN of the IAM role to be used by the notebook instance which allows SageMaker to call other services on your behalf.
     */
    @JvmName("eqcoaxgowdkgqwbo")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Whether root access is `Enabled` or `Disabled` for users of the notebook instance. The default value is `Enabled`.
     */
    @JvmName("yelnjsnmlgpjnvxi")
    public suspend fun rootAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootAccess = mapped
    }

    /**
     * @param value The associated security groups.
     */
    @JvmName("pqmfkreqgvxuadeu")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The associated security groups.
     */
    @JvmName("tfjuuhwxnqlhnrak")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The VPC subnet ID.
     */
    @JvmName("tbbhwbsgmnqvfpie")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ognsbtdtddwpunlj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kxdlhttxhtvmjily")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     */
    @JvmName("getrmkktemcdlswt")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    internal fun build(): NotebookInstanceArgs = NotebookInstanceArgs(
        acceleratorTypes = acceleratorTypes,
        additionalCodeRepositories = additionalCodeRepositories,
        defaultCodeRepository = defaultCodeRepository,
        directInternetAccess = directInternetAccess,
        instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration,
        instanceType = instanceType,
        kmsKeyId = kmsKeyId,
        lifecycleConfigName = lifecycleConfigName,
        name = name,
        platformIdentifier = platformIdentifier,
        roleArn = roleArn,
        rootAccess = rootAccess,
        securityGroups = securityGroups,
        subnetId = subnetId,
        tags = tags,
        volumeSize = volumeSize,
    )
}
