@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NotebookInstanceLifecycleConfiguration].
 */
@PulumiTagMarker
public class NotebookInstanceLifecycleConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotebookInstanceLifecycleConfigurationArgs =
        NotebookInstanceLifecycleConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend NotebookInstanceLifecycleConfigurationArgsBuilder.() -> Unit) {
        val builder = NotebookInstanceLifecycleConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NotebookInstanceLifecycleConfiguration {
        val builtJavaResource =
            com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotebookInstanceLifecycleConfiguration(builtJavaResource)
    }
}

/**
 * Provides a lifecycle configuration for SageMaker Notebook Instances.
 * ## Import
 * Using `pulumi import`, import models using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration lc foo
 * ```
 *
 */
public class NotebookInstanceLifecycleConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration,
) : KotlinCustomResource(javaResource, NotebookInstanceLifecycleConfigurationMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this lifecycle configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
     */
    public val onCreate: Output<String>?
        get() = javaResource.onCreate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
     */
    public val onStart: Output<String>?
        get() = javaResource.onStart().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NotebookInstanceLifecycleConfigurationMapper :
    ResourceMapper<NotebookInstanceLifecycleConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): NotebookInstanceLifecycleConfiguration =
        NotebookInstanceLifecycleConfiguration(
            javaResource as
                com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration,
        )
}

/**
 * @see [NotebookInstanceLifecycleConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotebookInstanceLifecycleConfiguration].
 */
public suspend fun notebookInstanceLifecycleConfiguration(
    name: String,
    block: suspend NotebookInstanceLifecycleConfigurationResourceBuilder.() -> Unit,
):
    NotebookInstanceLifecycleConfiguration {
    val builder = NotebookInstanceLifecycleConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotebookInstanceLifecycleConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notebookInstanceLifecycleConfiguration(name: String):
    NotebookInstanceLifecycleConfiguration {
    val builder = NotebookInstanceLifecycleConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
