@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a lifecycle configuration for SageMaker Notebook Instances.
 * ## Import
 * Using `pulumi import`, import models using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration lc foo
 * ```
 * @property name The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
 * @property onCreate A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
 * @property onStart A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
 */
public data class NotebookInstanceLifecycleConfigurationArgs(
    public val name: Output<String>? = null,
    public val onCreate: Output<String>? = null,
    public val onStart: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs =
        com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .onCreate(onCreate?.applyValue({ args0 -> args0 }))
            .onStart(onStart?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotebookInstanceLifecycleConfigurationArgs].
 */
@PulumiTagMarker
public class NotebookInstanceLifecycleConfigurationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var onCreate: Output<String>? = null

    private var onStart: Output<String>? = null

    /**
     * @param value The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("dbcxwvitlkpvvpbq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
     */
    @JvmName("lupaxhtmbppcuwjm")
    public suspend fun onCreate(`value`: Output<String>) {
        this.onCreate = value
    }

    /**
     * @param value A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
     */
    @JvmName("rpfuhlkvtyvpjlwv")
    public suspend fun onStart(`value`: Output<String>) {
        this.onStart = value
    }

    /**
     * @param value The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("duampemrdqnrhjtc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
     */
    @JvmName("rkrnjdhttbdyqifo")
    public suspend fun onCreate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onCreate = mapped
    }

    /**
     * @param value A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
     */
    @JvmName("bpmbeqcsywmrsbel")
    public suspend fun onStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onStart = mapped
    }

    internal fun build(): NotebookInstanceLifecycleConfigurationArgs =
        NotebookInstanceLifecycleConfigurationArgs(
            name = name,
            onCreate = onCreate,
            onStart = onStart,
        )
}
