@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.PipelineParallelismConfiguration
import com.pulumi.aws.sagemaker.kotlin.outputs.PipelinePipelineDefinitionS3Location
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.PipelineParallelismConfiguration.Companion.toKotlin as pipelineParallelismConfigurationToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.PipelinePipelineDefinitionS3Location.Companion.toKotlin as pipelinePipelineDefinitionS3LocationToKotlin

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource = com.pulumi.aws.sagemaker.Pipeline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pipeline(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Pipeline resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Pipeline;
 * import com.pulumi.aws.sagemaker.PipelineArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipeline("example", PipelineArgs.builder()
 *             .pipelineName("example")
 *             .pipelineDisplayName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .pipelineDefinition(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2020-12-01"),
 *                     jsonProperty("Steps", jsonArray(jsonObject(
 *                         jsonProperty("Name", "Test"),
 *                         jsonProperty("Type", "Fail"),
 *                         jsonProperty("Arguments", jsonObject(
 *                             jsonProperty("ErrorMessage", "test")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import pipelines using the `pipeline_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/pipeline:Pipeline test_pipeline pipeline
 * ```
 *
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Pipeline.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
     */
    public val parallelismConfiguration: Output<PipelineParallelismConfiguration>?
        get() = javaResource.parallelismConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelineParallelismConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
     */
    public val pipelineDefinition: Output<String>?
        get() = javaResource.pipelineDefinition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
     */
    public val pipelineDefinitionS3Location: Output<PipelinePipelineDefinitionS3Location>?
        get() = javaResource.pipelineDefinitionS3Location().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelinePipelineDefinitionS3LocationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A description of the pipeline.
     */
    public val pipelineDescription: Output<String>?
        get() = javaResource.pipelineDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the pipeline.
     */
    public val pipelineDisplayName: Output<String>
        get() = javaResource.pipelineDisplayName().applyValue({ args0 -> args0 })

    /**
     * The name of the pipeline.
     */
    public val pipelineName: Output<String>
        get() = javaResource.pipelineName().applyValue({ args0 -> args0 })

    /**
     * The name of the Pipeline (must be unique).
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.aws.sagemaker.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit):
    Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
