@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.PipelineArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelineParallelismConfigurationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelineParallelismConfigurationArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelinePipelineDefinitionS3LocationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelinePipelineDefinitionS3LocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Pipeline resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Pipeline;
 * import com.pulumi.aws.sagemaker.PipelineArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipeline("example", PipelineArgs.builder()
 *             .pipelineName("example")
 *             .pipelineDisplayName("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .pipelineDefinition(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2020-12-01"),
 *                     jsonProperty("Steps", jsonArray(jsonObject(
 *                         jsonProperty("Name", "Test"),
 *                         jsonProperty("Type", "Fail"),
 *                         jsonProperty("Arguments", jsonObject(
 *                             jsonProperty("ErrorMessage", "test")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import pipelines using the `pipeline_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/pipeline:Pipeline test_pipeline pipeline
 * ```
 * @property parallelismConfiguration This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
 * @property pipelineDefinition The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
 * @property pipelineDefinitionS3Location The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
 * @property pipelineDescription A description of the pipeline.
 * @property pipelineDisplayName The display name of the pipeline.
 * @property pipelineName The name of the pipeline.
 * @property roleArn The name of the Pipeline (must be unique).
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PipelineArgs(
    public val parallelismConfiguration: Output<PipelineParallelismConfigurationArgs>? = null,
    public val pipelineDefinition: Output<String>? = null,
    public val pipelineDefinitionS3Location: Output<PipelinePipelineDefinitionS3LocationArgs>? = null,
    public val pipelineDescription: Output<String>? = null,
    public val pipelineDisplayName: Output<String>? = null,
    public val pipelineName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.PipelineArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.PipelineArgs =
        com.pulumi.aws.sagemaker.PipelineArgs.builder()
            .parallelismConfiguration(
                parallelismConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .pipelineDefinition(pipelineDefinition?.applyValue({ args0 -> args0 }))
            .pipelineDefinitionS3Location(
                pipelineDefinitionS3Location?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .pipelineDescription(pipelineDescription?.applyValue({ args0 -> args0 }))
            .pipelineDisplayName(pipelineDisplayName?.applyValue({ args0 -> args0 }))
            .pipelineName(pipelineName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var parallelismConfiguration: Output<PipelineParallelismConfigurationArgs>? = null

    private var pipelineDefinition: Output<String>? = null

    private var pipelineDefinitionS3Location: Output<PipelinePipelineDefinitionS3LocationArgs>? = null

    private var pipelineDescription: Output<String>? = null

    private var pipelineDisplayName: Output<String>? = null

    private var pipelineName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
     */
    @JvmName("jjdjgossboxngcyk")
    public suspend
    fun parallelismConfiguration(`value`: Output<PipelineParallelismConfigurationArgs>) {
        this.parallelismConfiguration = value
    }

    /**
     * @param value The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
     */
    @JvmName("egncgwyflynkioak")
    public suspend fun pipelineDefinition(`value`: Output<String>) {
        this.pipelineDefinition = value
    }

    /**
     * @param value The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
     */
    @JvmName("aicqyvtfashtqvwy")
    public suspend
    fun pipelineDefinitionS3Location(`value`: Output<PipelinePipelineDefinitionS3LocationArgs>) {
        this.pipelineDefinitionS3Location = value
    }

    /**
     * @param value A description of the pipeline.
     */
    @JvmName("oipdivdfossampdk")
    public suspend fun pipelineDescription(`value`: Output<String>) {
        this.pipelineDescription = value
    }

    /**
     * @param value The display name of the pipeline.
     */
    @JvmName("nkyrlbsmjqgpvovw")
    public suspend fun pipelineDisplayName(`value`: Output<String>) {
        this.pipelineDisplayName = value
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("phwyfxpdwgcekuwt")
    public suspend fun pipelineName(`value`: Output<String>) {
        this.pipelineName = value
    }

    /**
     * @param value The name of the Pipeline (must be unique).
     */
    @JvmName("smyqonpvdjbosmlv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rqcdauoftbhytput")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
     */
    @JvmName("mwovtcaalvmijhha")
    public suspend fun parallelismConfiguration(`value`: PipelineParallelismConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelismConfiguration = mapped
    }

    /**
     * @param argument This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
     */
    @JvmName("cbkaheesatwixgwb")
    public suspend
    fun parallelismConfiguration(argument: suspend PipelineParallelismConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineParallelismConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parallelismConfiguration = mapped
    }

    /**
     * @param value The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
     */
    @JvmName("klldbwffucynfuaw")
    public suspend fun pipelineDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDefinition = mapped
    }

    /**
     * @param value The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
     */
    @JvmName("jhiiksqqkmlduyrw")
    public suspend
    fun pipelineDefinitionS3Location(`value`: PipelinePipelineDefinitionS3LocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDefinitionS3Location = mapped
    }

    /**
     * @param argument The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
     */
    @JvmName("crlxxanqtvuoxdkg")
    public suspend
    fun pipelineDefinitionS3Location(argument: suspend PipelinePipelineDefinitionS3LocationArgsBuilder.() -> Unit) {
        val toBeMapped = PipelinePipelineDefinitionS3LocationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.pipelineDefinitionS3Location = mapped
    }

    /**
     * @param value A description of the pipeline.
     */
    @JvmName("wbntvftofbfllfva")
    public suspend fun pipelineDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDescription = mapped
    }

    /**
     * @param value The display name of the pipeline.
     */
    @JvmName("cxgqlpmhthfefhhy")
    public suspend fun pipelineDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDisplayName = mapped
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("ruysyoechpyrxspq")
    public suspend fun pipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineName = mapped
    }

    /**
     * @param value The name of the Pipeline (must be unique).
     */
    @JvmName("ehdueqytieebuneg")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rcbwssfvrsqbtadv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ryxkojnikktqjrmq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        parallelismConfiguration = parallelismConfiguration,
        pipelineDefinition = pipelineDefinition,
        pipelineDefinitionS3Location = pipelineDefinitionS3Location,
        pipelineDescription = pipelineDescription,
        pipelineDisplayName = pipelineDisplayName,
        pipelineName = pipelineName,
        roleArn = roleArn,
        tags = tags,
    )
}
