@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.ProjectServiceCatalogProvisioningDetails
import com.pulumi.aws.sagemaker.kotlin.outputs.ProjectServiceCatalogProvisioningDetails.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.aws.sagemaker.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Project resource.
 *  > Note: If you are trying to use SageMaker projects with SageMaker studio you will need to add a tag with the key `sagemaker:studio-visibility` with value `true`. For more on requirements to use projects and permission needed see [AWS Docs](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-projects-templates-custom.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Project;
 * import com.pulumi.aws.sagemaker.ProjectArgs;
 * import com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .projectName("example")
 *             .serviceCatalogProvisioningDetails(ProjectServiceCatalogProvisioningDetailsArgs.builder()
 *                 .productId(aws_servicecatalog_product.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Projects using the `project_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/project:Project example example
 * ```
 *
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Project.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description for the project.
     */
    public val projectDescription: Output<String>?
        get() = javaResource.projectDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the project.
     */
    public val projectId: Output<String>
        get() = javaResource.projectId().applyValue({ args0 -> args0 })

    /**
     * The name of the Project.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
     */
    public val serviceCatalogProvisioningDetails: Output<ProjectServiceCatalogProvisioningDetails>
        get() = javaResource.serviceCatalogProvisioningDetails().applyValue({ args0 ->
            args0.let({ args0 -> toKotlin(args0) })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.aws.sagemaker.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit):
    Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
