@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ProjectArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.ProjectServiceCatalogProvisioningDetailsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ProjectServiceCatalogProvisioningDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Project resource.
 *  > Note: If you are trying to use SageMaker projects with SageMaker studio you will need to add a tag with the key `sagemaker:studio-visibility` with value `true`. For more on requirements to use projects and permission needed see [AWS Docs](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-projects-templates-custom.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Project;
 * import com.pulumi.aws.sagemaker.ProjectArgs;
 * import com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .projectName("example")
 *             .serviceCatalogProvisioningDetails(ProjectServiceCatalogProvisioningDetailsArgs.builder()
 *                 .productId(aws_servicecatalog_product.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Projects using the `project_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/project:Project example example
 * ```
 * @property projectDescription A description for the project.
 * @property projectName The name of the Project.
 * @property serviceCatalogProvisioningDetails The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProjectArgs(
    public val projectDescription: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val serviceCatalogProvisioningDetails:
    Output<ProjectServiceCatalogProvisioningDetailsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ProjectArgs =
        com.pulumi.aws.sagemaker.ProjectArgs.builder()
            .projectDescription(projectDescription?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .serviceCatalogProvisioningDetails(
                serviceCatalogProvisioningDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var projectDescription: Output<String>? = null

    private var projectName: Output<String>? = null

    private var serviceCatalogProvisioningDetails:
        Output<ProjectServiceCatalogProvisioningDetailsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description for the project.
     */
    @JvmName("hfsnbhqcucandbtc")
    public suspend fun projectDescription(`value`: Output<String>) {
        this.projectDescription = value
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("cnkebwsaxrssntwn")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
     */
    @JvmName("guhedxitbnyosenk")
    public suspend
    fun serviceCatalogProvisioningDetails(`value`: Output<ProjectServiceCatalogProvisioningDetailsArgs>) {
        this.serviceCatalogProvisioningDetails = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qnqqcjgsxmafrajq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description for the project.
     */
    @JvmName("lgbathksggwaawgq")
    public suspend fun projectDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectDescription = mapped
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("rjkuoucwkgbbcwhg")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
     */
    @JvmName("siwxgvpiuytqpjwo")
    public suspend
    fun serviceCatalogProvisioningDetails(`value`: ProjectServiceCatalogProvisioningDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCatalogProvisioningDetails = mapped
    }

    /**
     * @param argument The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
     */
    @JvmName("heqnormoyvspnqds")
    public suspend
    fun serviceCatalogProvisioningDetails(argument: suspend ProjectServiceCatalogProvisioningDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectServiceCatalogProvisioningDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceCatalogProvisioningDetails = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ifsxivieyouwdmdy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("everalcxilrpclqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        projectDescription = projectDescription,
        projectName = projectName,
        serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails,
        tags = tags,
    )
}
