@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.SagemakerFunctions.getPrebuiltEcrImagePlain
import com.pulumi.aws.sagemaker.kotlin.inputs.GetPrebuiltEcrImagePlainArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.GetPrebuiltEcrImagePlainArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.outputs.GetPrebuiltEcrImageResult
import com.pulumi.aws.sagemaker.kotlin.outputs.GetPrebuiltEcrImageResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object SagemakerFunctions {
    /**
     * Get information about prebuilt Amazon SageMaker Docker images.
     * > **NOTE:** The AWS provider creates a validly constructed `registry_path` but does not verify that the `registry_path` corresponds to an existing image. For example, using a `registry_path` containing an `image_tag` that does not correspond to a Docker image in the ECR repository, will result in an error.
     * ## Example Usage
     * Basic usage:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sagemaker.SagemakerFunctions;
     * import com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImageArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = SagemakerFunctions.getPrebuiltEcrImage(GetPrebuiltEcrImageArgs.builder()
     *             .imageTag("2.2-1.0.11.0")
     *             .repositoryName("sagemaker-scikit-learn")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPrebuiltEcrImage.
     * @return A collection of values returned by getPrebuiltEcrImage.
     */
    public suspend fun getPrebuiltEcrImage(argument: GetPrebuiltEcrImagePlainArgs):
        GetPrebuiltEcrImageResult = toKotlin(getPrebuiltEcrImagePlain(argument.toJava()).await())

    /**
     * @see [getPrebuiltEcrImage].
     * @param dnsSuffix DNS suffix to use in the registry path. If not specified, the AWS provider sets it to the DNS suffix for the current region.
     * @param imageTag Image tag for the Docker image. If not specified, the AWS provider sets the value to `1`, which for many repositories indicates the latest version. Some repositories, such as XGBoost, do not support `1` or `latest` and specific version must be used.
     * @param region Region to use in the registry path. If not specified, the AWS provider sets it to the current region.
     * @param repositoryName Name of the repository, which is generally the algorithm or library. Values include `blazingtext`, `factorization-machines`, `forecasting-deepar`, `image-classification`, `ipinsights`, `kmeans`, `knn`, `lda`, `linear-learner`, `mxnet-inference-eia`, `mxnet-inference`, `mxnet-training`, `ntm`, `object-detection`, `object2vec`, `pca`, `pytorch-inference-eia`, `pytorch-inference`, `pytorch-training`, `randomcutforest`, `sagemaker-scikit-learn`, `sagemaker-sparkml-serving`, `sagemaker-xgboost`, `semantic-segmentation`, `seq2seq`, `tensorflow-inference-eia`, `tensorflow-inference`, `tensorflow-training`, `huggingface-tensorflow-training`, `huggingface-tensorflow-inference`, `huggingface-pytorch-training`, and `huggingface-pytorch-inference`.
     * @return A collection of values returned by getPrebuiltEcrImage.
     */
    public suspend fun getPrebuiltEcrImage(
        dnsSuffix: String? = null,
        imageTag: String? = null,
        region: String? = null,
        repositoryName: String,
    ): GetPrebuiltEcrImageResult {
        val argument = GetPrebuiltEcrImagePlainArgs(
            dnsSuffix = dnsSuffix,
            imageTag = imageTag,
            region = region,
            repositoryName = repositoryName,
        )
        return toKotlin(getPrebuiltEcrImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrebuiltEcrImage].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sagemaker&#46;kotlin&#46;inputs&#46;GetPrebuiltEcrImagePlainArgs].
     * @return A collection of values returned by getPrebuiltEcrImage.
     */
    public suspend
    fun getPrebuiltEcrImage(argument: suspend GetPrebuiltEcrImagePlainArgsBuilder.() -> Unit):
        GetPrebuiltEcrImageResult {
        val builder = GetPrebuiltEcrImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getPrebuiltEcrImagePlain(builtArgument.toJava()).await())
    }
}
