@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServicecatalogPortfolioStatus].
 */
@PulumiTagMarker
public class ServicecatalogPortfolioStatusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServicecatalogPortfolioStatusArgs = ServicecatalogPortfolioStatusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServicecatalogPortfolioStatusArgsBuilder.() -> Unit) {
        val builder = ServicecatalogPortfolioStatusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServicecatalogPortfolioStatus {
        val builtJavaResource =
            com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatus(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServicecatalogPortfolioStatus(builtJavaResource)
    }
}

/**
 * Manages status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
 * ## Example Usage
 * Usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatus;
 * import com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServicecatalogPortfolioStatus("example", ServicecatalogPortfolioStatusArgs.builder()
 *             .status("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import models using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/servicecatalogPortfolioStatus:ServicecatalogPortfolioStatus example us-east-1
 * ```
 *
 */
public class ServicecatalogPortfolioStatus internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatus,
) : KotlinCustomResource(javaResource, ServicecatalogPortfolioStatusMapper) {
    /**
     * Whether Service Catalog is enabled or disabled in SageMaker. Valid values are `Enabled` and `Disabled`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ServicecatalogPortfolioStatusMapper : ResourceMapper<ServicecatalogPortfolioStatus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatus::class == javaResource::class

    override fun map(javaResource: Resource): ServicecatalogPortfolioStatus =
        ServicecatalogPortfolioStatus(
            javaResource as
                com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatus,
        )
}

/**
 * @see [ServicecatalogPortfolioStatus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServicecatalogPortfolioStatus].
 */
public suspend fun servicecatalogPortfolioStatus(
    name: String,
    block: suspend ServicecatalogPortfolioStatusResourceBuilder.() -> Unit,
):
    ServicecatalogPortfolioStatus {
    val builder = ServicecatalogPortfolioStatusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServicecatalogPortfolioStatus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun servicecatalogPortfolioStatus(name: String): ServicecatalogPortfolioStatus {
    val builder = ServicecatalogPortfolioStatusResourceBuilder()
    builder.name(name)
    return builder.build()
}
