@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
 * ## Example Usage
 * Usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatus;
 * import com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServicecatalogPortfolioStatus("example", ServicecatalogPortfolioStatusArgs.builder()
 *             .status("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import models using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/servicecatalogPortfolioStatus:ServicecatalogPortfolioStatus example us-east-1
 * ```
 * @property status Whether Service Catalog is enabled or disabled in SageMaker. Valid values are `Enabled` and `Disabled`.
 */
public data class ServicecatalogPortfolioStatusArgs(
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatusArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatusArgs =
        com.pulumi.aws.sagemaker.ServicecatalogPortfolioStatusArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicecatalogPortfolioStatusArgs].
 */
@PulumiTagMarker
public class ServicecatalogPortfolioStatusArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Whether Service Catalog is enabled or disabled in SageMaker. Valid values are `Enabled` and `Disabled`.
     */
    @JvmName("wwrehtyhfatskgbp")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether Service Catalog is enabled or disabled in SageMaker. Valid values are `Enabled` and `Disabled`.
     */
    @JvmName("bmarihyvquodhumy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ServicecatalogPortfolioStatusArgs = ServicecatalogPortfolioStatusArgs(
        status = status,
    )
}
