@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Space].
 */
@PulumiTagMarker
public class SpaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpaceArgs = SpaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpaceArgsBuilder.() -> Unit) {
        val builder = SpaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Space {
        val builtJavaResource = com.pulumi.aws.sagemaker.Space(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Space(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Space resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Space;
 * import com.pulumi.aws.sagemaker.SpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Space("example", SpaceArgs.builder()
 *             .domainId(aws_sagemaker_domain.test().id())
 *             .spaceName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Spaces using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/space:Space test_space arn:aws:sagemaker:us-west-2:123456789012:space/domain-id/space-name
 * ```
 *
 */
public class Space internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Space,
) : KotlinCustomResource(javaResource, SpaceMapper) {
    /**
     * The space's Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the associated Domain.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * The ID of the space's profile in the Amazon Elastic File System volume.
     */
    public val homeEfsFileSystemUid: Output<String>
        get() = javaResource.homeEfsFileSystemUid().applyValue({ args0 -> args0 })

    /**
     * The name of the space.
     */
    public val spaceName: Output<String>
        get() = javaResource.spaceName().applyValue({ args0 -> args0 })

    /**
     * A collection of space settings. See Space Settings below.
     */
    public val spaceSettings: Output<SpaceSpaceSettings>?
        get() = javaResource.spaceSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SpaceMapper : ResourceMapper<Space> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Space::class == javaResource::class

    override fun map(javaResource: Resource): Space = Space(
        javaResource as
            com.pulumi.aws.sagemaker.Space,
    )
}

/**
 * @see [Space].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Space].
 */
public suspend fun space(name: String, block: suspend SpaceResourceBuilder.() -> Unit): Space {
    val builder = SpaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Space].
 * @param name The _unique_ name of the resulting resource.
 */
public fun space(name: String): Space {
    val builder = SpaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
