@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.SpaceArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceSpaceSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceSpaceSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Space resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Space;
 * import com.pulumi.aws.sagemaker.SpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Space("example", SpaceArgs.builder()
 *             .domainId(aws_sagemaker_domain.test().id())
 *             .spaceName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Spaces using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/space:Space test_space arn:aws:sagemaker:us-west-2:123456789012:space/domain-id/space-name
 * ```
 * @property domainId The ID of the associated Domain.
 * @property spaceName The name of the space.
 * @property spaceSettings A collection of space settings. See Space Settings below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SpaceArgs(
    public val domainId: Output<String>? = null,
    public val spaceName: Output<String>? = null,
    public val spaceSettings: Output<SpaceSpaceSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.SpaceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.SpaceArgs =
        com.pulumi.aws.sagemaker.SpaceArgs.builder()
            .domainId(domainId?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 }))
            .spaceSettings(spaceSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SpaceArgs].
 */
@PulumiTagMarker
public class SpaceArgsBuilder internal constructor() {
    private var domainId: Output<String>? = null

    private var spaceName: Output<String>? = null

    private var spaceSettings: Output<SpaceSpaceSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the associated Domain.
     */
    @JvmName("lomtpcexyggggfoa")
    public suspend fun domainId(`value`: Output<String>) {
        this.domainId = value
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("mvrcexvfmnaudrbn")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value A collection of space settings. See Space Settings below.
     */
    @JvmName("einchuksgkvceicg")
    public suspend fun spaceSettings(`value`: Output<SpaceSpaceSettingsArgs>) {
        this.spaceSettings = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jjaskhqwsanbmckd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the associated Domain.
     */
    @JvmName("boeonjslhapugpok")
    public suspend fun domainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainId = mapped
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("fxpcwojngfpwpwtc")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    /**
     * @param value A collection of space settings. See Space Settings below.
     */
    @JvmName("jytbqqfouwtcqojo")
    public suspend fun spaceSettings(`value`: SpaceSpaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceSettings = mapped
    }

    /**
     * @param argument A collection of space settings. See Space Settings below.
     */
    @JvmName("juxgheymqowlqwok")
    public suspend fun spaceSettings(argument: suspend SpaceSpaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spaceSettings = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xkwtmxxiruecfble")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ljxjwvwduhgavkwl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SpaceArgs = SpaceArgs(
        domainId = domainId,
        spaceName = spaceName,
        spaceSettings = spaceSettings,
        tags = tags,
    )
}
