@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [StudioLifecycleConfig].
 */
@PulumiTagMarker
public class StudioLifecycleConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StudioLifecycleConfigArgs = StudioLifecycleConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StudioLifecycleConfigArgsBuilder.() -> Unit) {
        val builder = StudioLifecycleConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StudioLifecycleConfig {
        val builtJavaResource = com.pulumi.aws.sagemaker.StudioLifecycleConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StudioLifecycleConfig(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Studio Lifecycle Config resource.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import SageMaker Studio Lifecycle Configs using the `studio_lifecycle_config_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig example example
 * ```
 *
 */
public class StudioLifecycleConfig internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.StudioLifecycleConfig,
) : KotlinCustomResource(javaResource, StudioLifecycleConfigMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Studio Lifecycle Config.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer` and `KernelGateway`.
     */
    public val studioLifecycleConfigAppType: Output<String>
        get() = javaResource.studioLifecycleConfigAppType().applyValue({ args0 -> args0 })

    /**
     * The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     */
    public val studioLifecycleConfigContent: Output<String>
        get() = javaResource.studioLifecycleConfigContent().applyValue({ args0 -> args0 })

    /**
     * The name of the Studio Lifecycle Configuration to create.
     */
    public val studioLifecycleConfigName: Output<String>
        get() = javaResource.studioLifecycleConfigName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object StudioLifecycleConfigMapper : ResourceMapper<StudioLifecycleConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.StudioLifecycleConfig::class == javaResource::class

    override fun map(javaResource: Resource): StudioLifecycleConfig =
        StudioLifecycleConfig(javaResource as com.pulumi.aws.sagemaker.StudioLifecycleConfig)
}

/**
 * @see [StudioLifecycleConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StudioLifecycleConfig].
 */
public suspend fun studioLifecycleConfig(
    name: String,
    block: suspend StudioLifecycleConfigResourceBuilder.() -> Unit,
): StudioLifecycleConfig {
    val builder = StudioLifecycleConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StudioLifecycleConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun studioLifecycleConfig(name: String): StudioLifecycleConfig {
    val builder = StudioLifecycleConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
