@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Studio Lifecycle Config resource.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import SageMaker Studio Lifecycle Configs using the `studio_lifecycle_config_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig example example
 * ```
 * @property studioLifecycleConfigAppType The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer` and `KernelGateway`.
 * @property studioLifecycleConfigContent The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
 * @property studioLifecycleConfigName The name of the Studio Lifecycle Configuration to create.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StudioLifecycleConfigArgs(
    public val studioLifecycleConfigAppType: Output<String>? = null,
    public val studioLifecycleConfigContent: Output<String>? = null,
    public val studioLifecycleConfigName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs =
        com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs.builder()
            .studioLifecycleConfigAppType(studioLifecycleConfigAppType?.applyValue({ args0 -> args0 }))
            .studioLifecycleConfigContent(studioLifecycleConfigContent?.applyValue({ args0 -> args0 }))
            .studioLifecycleConfigName(studioLifecycleConfigName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StudioLifecycleConfigArgs].
 */
@PulumiTagMarker
public class StudioLifecycleConfigArgsBuilder internal constructor() {
    private var studioLifecycleConfigAppType: Output<String>? = null

    private var studioLifecycleConfigContent: Output<String>? = null

    private var studioLifecycleConfigName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer` and `KernelGateway`.
     */
    @JvmName("tiumdxjpmtjfhwdc")
    public suspend fun studioLifecycleConfigAppType(`value`: Output<String>) {
        this.studioLifecycleConfigAppType = value
    }

    /**
     * @param value The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     */
    @JvmName("kywxfdexrpwxaebg")
    public suspend fun studioLifecycleConfigContent(`value`: Output<String>) {
        this.studioLifecycleConfigContent = value
    }

    /**
     * @param value The name of the Studio Lifecycle Configuration to create.
     */
    @JvmName("jvnfrftuxrhtmcjd")
    public suspend fun studioLifecycleConfigName(`value`: Output<String>) {
        this.studioLifecycleConfigName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ufbetyadxtwuvlps")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer` and `KernelGateway`.
     */
    @JvmName("vprhdqabttewtjfl")
    public suspend fun studioLifecycleConfigAppType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioLifecycleConfigAppType = mapped
    }

    /**
     * @param value The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     */
    @JvmName("aqjnjqaplyrtfwke")
    public suspend fun studioLifecycleConfigContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioLifecycleConfigContent = mapped
    }

    /**
     * @param value The name of the Studio Lifecycle Configuration to create.
     */
    @JvmName("biqbtcfhmpavxcrm")
    public suspend fun studioLifecycleConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioLifecycleConfigName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mayigfmojjrvwypv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tpjodjyevbekylfr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StudioLifecycleConfigArgs = StudioLifecycleConfigArgs(
        studioLifecycleConfigAppType = studioLifecycleConfigAppType,
        studioLifecycleConfigContent = studioLifecycleConfigContent,
        studioLifecycleConfigName = studioLifecycleConfigName,
        tags = tags,
    )
}
