@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.UserProfileArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.UserProfileUserSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.UserProfileUserSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker User Profile resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.UserProfile;
 * import com.pulumi.aws.sagemaker.UserProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserProfile("example", UserProfileArgs.builder()
 *             .domainId(aws_sagemaker_domain.test().id())
 *             .userProfileName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker User Profiles using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/userProfile:UserProfile test_user_profile arn:aws:sagemaker:us-west-2:123456789012:user-profile/domain-id/profile-name
 * ```
 * @property domainId The ID of the associated Domain.
 * @property singleSignOnUserIdentifier A specifier for the type of value specified in `single_sign_on_user_value`. Currently, the only supported value is `UserName`. If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified.
 * @property singleSignOnUserValue The username of the associated AWS Single Sign-On User for this User Profile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userProfileName The name for the User Profile.
 * @property userSettings The user settings. See User Settings below.
 */
public data class UserProfileArgs(
    public val domainId: Output<String>? = null,
    public val singleSignOnUserIdentifier: Output<String>? = null,
    public val singleSignOnUserValue: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userProfileName: Output<String>? = null,
    public val userSettings: Output<UserProfileUserSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.UserProfileArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.UserProfileArgs =
        com.pulumi.aws.sagemaker.UserProfileArgs.builder()
            .domainId(domainId?.applyValue({ args0 -> args0 }))
            .singleSignOnUserIdentifier(singleSignOnUserIdentifier?.applyValue({ args0 -> args0 }))
            .singleSignOnUserValue(singleSignOnUserValue?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userProfileName(userProfileName?.applyValue({ args0 -> args0 }))
            .userSettings(userSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [UserProfileArgs].
 */
@PulumiTagMarker
public class UserProfileArgsBuilder internal constructor() {
    private var domainId: Output<String>? = null

    private var singleSignOnUserIdentifier: Output<String>? = null

    private var singleSignOnUserValue: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userProfileName: Output<String>? = null

    private var userSettings: Output<UserProfileUserSettingsArgs>? = null

    /**
     * @param value The ID of the associated Domain.
     */
    @JvmName("tklfxecrngbnafem")
    public suspend fun domainId(`value`: Output<String>) {
        this.domainId = value
    }

    /**
     * @param value A specifier for the type of value specified in `single_sign_on_user_value`. Currently, the only supported value is `UserName`. If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    @JvmName("dmjukxjxkguhhlbn")
    public suspend fun singleSignOnUserIdentifier(`value`: Output<String>) {
        this.singleSignOnUserIdentifier = value
    }

    /**
     * @param value The username of the associated AWS Single Sign-On User for this User Profile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    @JvmName("urrdhhevcqgpurkk")
    public suspend fun singleSignOnUserValue(`value`: Output<String>) {
        this.singleSignOnUserValue = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gxthinnarqycyugp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name for the User Profile.
     */
    @JvmName("nogfmrkxvuvieruv")
    public suspend fun userProfileName(`value`: Output<String>) {
        this.userProfileName = value
    }

    /**
     * @param value The user settings. See User Settings below.
     */
    @JvmName("jiioainkcuatreug")
    public suspend fun userSettings(`value`: Output<UserProfileUserSettingsArgs>) {
        this.userSettings = value
    }

    /**
     * @param value The ID of the associated Domain.
     */
    @JvmName("kthsbumbqohisayk")
    public suspend fun domainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainId = mapped
    }

    /**
     * @param value A specifier for the type of value specified in `single_sign_on_user_value`. Currently, the only supported value is `UserName`. If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    @JvmName("alfawmlxbenbckmo")
    public suspend fun singleSignOnUserIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleSignOnUserIdentifier = mapped
    }

    /**
     * @param value The username of the associated AWS Single Sign-On User for this User Profile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    @JvmName("hadrubypfogyamgr")
    public suspend fun singleSignOnUserValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleSignOnUserValue = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iumxifhcelwhvtng")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ffdqphxchfsjnfat")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name for the User Profile.
     */
    @JvmName("whebjyuudfotlvnu")
    public suspend fun userProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProfileName = mapped
    }

    /**
     * @param value The user settings. See User Settings below.
     */
    @JvmName("rwintttsgonaevgn")
    public suspend fun userSettings(`value`: UserProfileUserSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSettings = mapped
    }

    /**
     * @param argument The user settings. See User Settings below.
     */
    @JvmName("dfyqwdkqorunievi")
    public suspend fun userSettings(argument: suspend UserProfileUserSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userSettings = mapped
    }

    internal fun build(): UserProfileArgs = UserProfileArgs(
        domainId = domainId,
        singleSignOnUserIdentifier = singleSignOnUserIdentifier,
        singleSignOnUserValue = singleSignOnUserValue,
        tags = tags,
        userProfileName = userProfileName,
        userSettings = userSettings,
    )
}
