@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.WorkforceArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceCognitoConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceCognitoConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceOidcConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceOidcConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceSourceIpConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceSourceIpConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceWorkforceVpcConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkforceWorkforceVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Workforce resource.
 * ## Example Usage
 * ### Cognito Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.sagemaker.Workforce;
 * import com.pulumi.aws.sagemaker.WorkforceArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkforceCognitoConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool");
 *         var exampleUserPoolClient = new UserPoolClient("exampleUserPoolClient", UserPoolClientArgs.builder()
 *             .generateSecret(true)
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolDomain = new UserPoolDomain("exampleUserPoolDomain", UserPoolDomainArgs.builder()
 *             .domain("example")
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleWorkforce = new Workforce("exampleWorkforce", WorkforceArgs.builder()
 *             .workforceName("example")
 *             .cognitoConfig(WorkforceCognitoConfigArgs.builder()
 *                 .clientId(exampleUserPoolClient.id())
 *                 .userPool(exampleUserPoolDomain.userPoolId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Oidc Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workforce;
 * import com.pulumi.aws.sagemaker.WorkforceArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkforceOidcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workforce("example", WorkforceArgs.builder()
 *             .oidcConfig(WorkforceOidcConfigArgs.builder()
 *                 .authorizationEndpoint("https://example.com")
 *                 .clientId("example")
 *                 .clientSecret("example")
 *                 .issuer("https://example.com")
 *                 .jwksUri("https://example.com")
 *                 .logoutEndpoint("https://example.com")
 *                 .tokenEndpoint("https://example.com")
 *                 .userInfoEndpoint("https://example.com")
 *                 .build())
 *             .workforceName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Workforces using the `workforce_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/workforce:Workforce example example
 * ```
 * @property cognitoConfig Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single Amazon Cognito user pool. Conflicts with `oidc_config`. see Cognito Config details below.
 * @property oidcConfig Use this parameter to configure a private workforce using your own OIDC Identity Provider. Conflicts with `cognito_config`. see OIDC Config details below.
 * @property sourceIpConfig A list of IP address ranges Used to create an allow list of IP addresses for a private workforce. By default, a workforce isn't restricted to specific IP addresses. see Source Ip Config details below.
 * @property workforceName The name of the Workforce (must be unique).
 * @property workforceVpcConfig configure a workforce using VPC. see Workforce VPC Config details below.
 */
public data class WorkforceArgs(
    public val cognitoConfig: Output<WorkforceCognitoConfigArgs>? = null,
    public val oidcConfig: Output<WorkforceOidcConfigArgs>? = null,
    public val sourceIpConfig: Output<WorkforceSourceIpConfigArgs>? = null,
    public val workforceName: Output<String>? = null,
    public val workforceVpcConfig: Output<WorkforceWorkforceVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.WorkforceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.WorkforceArgs =
        com.pulumi.aws.sagemaker.WorkforceArgs.builder()
            .cognitoConfig(cognitoConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .oidcConfig(oidcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceIpConfig(sourceIpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workforceName(workforceName?.applyValue({ args0 -> args0 }))
            .workforceVpcConfig(
                workforceVpcConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkforceArgs].
 */
@PulumiTagMarker
public class WorkforceArgsBuilder internal constructor() {
    private var cognitoConfig: Output<WorkforceCognitoConfigArgs>? = null

    private var oidcConfig: Output<WorkforceOidcConfigArgs>? = null

    private var sourceIpConfig: Output<WorkforceSourceIpConfigArgs>? = null

    private var workforceName: Output<String>? = null

    private var workforceVpcConfig: Output<WorkforceWorkforceVpcConfigArgs>? = null

    /**
     * @param value Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single Amazon Cognito user pool. Conflicts with `oidc_config`. see Cognito Config details below.
     */
    @JvmName("eytnuyvlyhesgmbh")
    public suspend fun cognitoConfig(`value`: Output<WorkforceCognitoConfigArgs>) {
        this.cognitoConfig = value
    }

    /**
     * @param value Use this parameter to configure a private workforce using your own OIDC Identity Provider. Conflicts with `cognito_config`. see OIDC Config details below.
     */
    @JvmName("fvowcexxyimbdkjm")
    public suspend fun oidcConfig(`value`: Output<WorkforceOidcConfigArgs>) {
        this.oidcConfig = value
    }

    /**
     * @param value A list of IP address ranges Used to create an allow list of IP addresses for a private workforce. By default, a workforce isn't restricted to specific IP addresses. see Source Ip Config details below.
     */
    @JvmName("qcfxmucbmerrlmlw")
    public suspend fun sourceIpConfig(`value`: Output<WorkforceSourceIpConfigArgs>) {
        this.sourceIpConfig = value
    }

    /**
     * @param value The name of the Workforce (must be unique).
     */
    @JvmName("tfahgxiitocfkoag")
    public suspend fun workforceName(`value`: Output<String>) {
        this.workforceName = value
    }

    /**
     * @param value configure a workforce using VPC. see Workforce VPC Config details below.
     */
    @JvmName("mklptkpyhqmtgupf")
    public suspend fun workforceVpcConfig(`value`: Output<WorkforceWorkforceVpcConfigArgs>) {
        this.workforceVpcConfig = value
    }

    /**
     * @param value Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single Amazon Cognito user pool. Conflicts with `oidc_config`. see Cognito Config details below.
     */
    @JvmName("najegjfuocosyavf")
    public suspend fun cognitoConfig(`value`: WorkforceCognitoConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoConfig = mapped
    }

    /**
     * @param argument Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single Amazon Cognito user pool. Conflicts with `oidc_config`. see Cognito Config details below.
     */
    @JvmName("kpehgudajifpvmfp")
    public suspend fun cognitoConfig(argument: suspend WorkforceCognitoConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WorkforceCognitoConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cognitoConfig = mapped
    }

    /**
     * @param value Use this parameter to configure a private workforce using your own OIDC Identity Provider. Conflicts with `cognito_config`. see OIDC Config details below.
     */
    @JvmName("jrhqbykqfygpcbms")
    public suspend fun oidcConfig(`value`: WorkforceOidcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcConfig = mapped
    }

    /**
     * @param argument Use this parameter to configure a private workforce using your own OIDC Identity Provider. Conflicts with `cognito_config`. see OIDC Config details below.
     */
    @JvmName("fyegeafyshrgytfy")
    public suspend fun oidcConfig(argument: suspend WorkforceOidcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WorkforceOidcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oidcConfig = mapped
    }

    /**
     * @param value A list of IP address ranges Used to create an allow list of IP addresses for a private workforce. By default, a workforce isn't restricted to specific IP addresses. see Source Ip Config details below.
     */
    @JvmName("mjibbmtmpssbltdf")
    public suspend fun sourceIpConfig(`value`: WorkforceSourceIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpConfig = mapped
    }

    /**
     * @param argument A list of IP address ranges Used to create an allow list of IP addresses for a private workforce. By default, a workforce isn't restricted to specific IP addresses. see Source Ip Config details below.
     */
    @JvmName("ctfljnpdospakkqg")
    public suspend
    fun sourceIpConfig(argument: suspend WorkforceSourceIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WorkforceSourceIpConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceIpConfig = mapped
    }

    /**
     * @param value The name of the Workforce (must be unique).
     */
    @JvmName("yxrbmynqfbhtaivc")
    public suspend fun workforceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workforceName = mapped
    }

    /**
     * @param value configure a workforce using VPC. see Workforce VPC Config details below.
     */
    @JvmName("ndxyaccanjgoxpfw")
    public suspend fun workforceVpcConfig(`value`: WorkforceWorkforceVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workforceVpcConfig = mapped
    }

    /**
     * @param argument configure a workforce using VPC. see Workforce VPC Config details below.
     */
    @JvmName("gjkqbccxkqhubqca")
    public suspend
    fun workforceVpcConfig(argument: suspend WorkforceWorkforceVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WorkforceWorkforceVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workforceVpcConfig = mapped
    }

    internal fun build(): WorkforceArgs = WorkforceArgs(
        cognitoConfig = cognitoConfig,
        oidcConfig = oidcConfig,
        sourceIpConfig = sourceIpConfig,
        workforceName = workforceName,
        workforceVpcConfig = workforceVpcConfig,
    )
}
