@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamMemberDefinition
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamNotificationConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamMemberDefinition.Companion.toKotlin as workteamMemberDefinitionToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamNotificationConfiguration.Companion.toKotlin as workteamNotificationConfigurationToKotlin

/**
 * Builder for [Workteam].
 */
@PulumiTagMarker
public class WorkteamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkteamArgs = WorkteamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkteamArgsBuilder.() -> Unit) {
        val builder = WorkteamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workteam {
        val builtJavaResource = com.pulumi.aws.sagemaker.Workteam(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workteam(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Workteam resource.
 * ## Example Usage
 * ### Cognito Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(aws_sagemaker_workforce.example().id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .cognitoMemberDefinition(WorkteamMemberDefinitionCognitoMemberDefinitionArgs.builder()
 *                     .clientId(aws_cognito_user_pool_client.example().id())
 *                     .userPool(aws_cognito_user_pool_domain.example().user_pool_id())
 *                     .userGroup(aws_cognito_user_group.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Oidc Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(aws_sagemaker_workforce.example().id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .oidcMemberDefinition(WorkteamMemberDefinitionOidcMemberDefinitionArgs.builder()
 *                     .groups("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Workteams using the `workteam_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/workteam:Workteam example example
 * ```
 *
 */
public class Workteam internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Workteam,
) : KotlinCustomResource(javaResource, WorkteamMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Workteam.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the work team.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    public val memberDefinitions: Output<List<WorkteamMemberDefinition>>
        get() = javaResource.memberDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workteamMemberDefinitionToKotlin(args0) })
            })
        })

    /**
     * Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    public val notificationConfiguration: Output<WorkteamNotificationConfiguration>?
        get() = javaResource.notificationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workteamNotificationConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The subdomain for your OIDC Identity Provider.
     */
    public val subdomain: Output<String>
        get() = javaResource.subdomain().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The name of the Workteam (must be unique).
     */
    public val workforceName: Output<String>
        get() = javaResource.workforceName().applyValue({ args0 -> args0 })

    /**
     * The name of the workforce.
     */
    public val workteamName: Output<String>
        get() = javaResource.workteamName().applyValue({ args0 -> args0 })
}

public object WorkteamMapper : ResourceMapper<Workteam> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Workteam::class == javaResource::class

    override fun map(javaResource: Resource): Workteam = Workteam(
        javaResource as
            com.pulumi.aws.sagemaker.Workteam,
    )
}

/**
 * @see [Workteam].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workteam].
 */
public suspend fun workteam(name: String, block: suspend WorkteamResourceBuilder.() -> Unit):
    Workteam {
    val builder = WorkteamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workteam].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workteam(name: String): Workteam {
    val builder = WorkteamResourceBuilder()
    builder.name(name)
    return builder.build()
}
