@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.WorkteamArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamMemberDefinitionArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamMemberDefinitionArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamNotificationConfigurationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamNotificationConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Workteam resource.
 * ## Example Usage
 * ### Cognito Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(aws_sagemaker_workforce.example().id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .cognitoMemberDefinition(WorkteamMemberDefinitionCognitoMemberDefinitionArgs.builder()
 *                     .clientId(aws_cognito_user_pool_client.example().id())
 *                     .userPool(aws_cognito_user_pool_domain.example().user_pool_id())
 *                     .userGroup(aws_cognito_user_group.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Oidc Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(aws_sagemaker_workforce.example().id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .oidcMemberDefinition(WorkteamMemberDefinitionOidcMemberDefinitionArgs.builder()
 *                     .groups("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SageMaker Workteams using the `workteam_name`. For example:
 * ```sh
 *  $ pulumi import aws:sagemaker/workteam:Workteam example example
 * ```
 * @property description A description of the work team.
 * @property memberDefinitions A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
 * @property notificationConfiguration Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workforceName The name of the Workteam (must be unique).
 * @property workteamName The name of the workforce.
 */
public data class WorkteamArgs(
    public val description: Output<String>? = null,
    public val memberDefinitions: Output<List<WorkteamMemberDefinitionArgs>>? = null,
    public val notificationConfiguration: Output<WorkteamNotificationConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workforceName: Output<String>? = null,
    public val workteamName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.WorkteamArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.WorkteamArgs =
        com.pulumi.aws.sagemaker.WorkteamArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .memberDefinitions(
                memberDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notificationConfiguration(
                notificationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workforceName(workforceName?.applyValue({ args0 -> args0 }))
            .workteamName(workteamName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkteamArgs].
 */
@PulumiTagMarker
public class WorkteamArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var memberDefinitions: Output<List<WorkteamMemberDefinitionArgs>>? = null

    private var notificationConfiguration: Output<WorkteamNotificationConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workforceName: Output<String>? = null

    private var workteamName: Output<String>? = null

    /**
     * @param value A description of the work team.
     */
    @JvmName("bwwuulwokulfocrm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("qajcwcgbepovgopf")
    public suspend fun memberDefinitions(`value`: Output<List<WorkteamMemberDefinitionArgs>>) {
        this.memberDefinitions = value
    }

    @JvmName("ngngngwkxqhyopne")
    public suspend fun memberDefinitions(vararg values: Output<WorkteamMemberDefinitionArgs>) {
        this.memberDefinitions = Output.all(values.asList())
    }

    /**
     * @param values A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("vhsveaewpgvxvtaw")
    public suspend fun memberDefinitions(values: List<Output<WorkteamMemberDefinitionArgs>>) {
        this.memberDefinitions = Output.all(values)
    }

    /**
     * @param value Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    @JvmName("tjxpawkrbrookith")
    public suspend
    fun notificationConfiguration(`value`: Output<WorkteamNotificationConfigurationArgs>) {
        this.notificationConfiguration = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ekbyxrewnvvtjlft")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Workteam (must be unique).
     */
    @JvmName("hblvhejpgtnfypjf")
    public suspend fun workforceName(`value`: Output<String>) {
        this.workforceName = value
    }

    /**
     * @param value The name of the workforce.
     */
    @JvmName("ffvgsgcyntmdlugi")
    public suspend fun workteamName(`value`: Output<String>) {
        this.workteamName = value
    }

    /**
     * @param value A description of the work team.
     */
    @JvmName("yupmfljgtktbgvue")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("vtvmcsigjtbevayd")
    public suspend fun memberDefinitions(`value`: List<WorkteamMemberDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberDefinitions = mapped
    }

    /**
     * @param argument A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("nmhliihpkrukwcri")
    public suspend
    fun memberDefinitions(argument: List<suspend WorkteamMemberDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkteamMemberDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.memberDefinitions = mapped
    }

    /**
     * @param argument A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("ygqmnavrfjqppxfk")
    public suspend fun memberDefinitions(
        vararg
        argument: suspend WorkteamMemberDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkteamMemberDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.memberDefinitions = mapped
    }

    /**
     * @param argument A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("wixvarixcctagija")
    public suspend
    fun memberDefinitions(argument: suspend WorkteamMemberDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkteamMemberDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.memberDefinitions = mapped
    }

    /**
     * @param values A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("macldnmlpklnqftu")
    public suspend fun memberDefinitions(vararg values: WorkteamMemberDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberDefinitions = mapped
    }

    /**
     * @param value Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    @JvmName("qakcwquaakrrscaf")
    public suspend fun notificationConfiguration(`value`: WorkteamNotificationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationConfiguration = mapped
    }

    /**
     * @param argument Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    @JvmName("odbhuwahkqopbxsd")
    public suspend
    fun notificationConfiguration(argument: suspend WorkteamNotificationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkteamNotificationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.notificationConfiguration = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wmsqcxpxltddcbsd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xneopwqoyxwrtuqn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the Workteam (must be unique).
     */
    @JvmName("sjlfixmjpeugirec")
    public suspend fun workforceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workforceName = mapped
    }

    /**
     * @param value The name of the workforce.
     */
    @JvmName("gbqhsouxvasflmun")
    public suspend fun workteamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workteamName = mapped
    }

    internal fun build(): WorkteamArgs = WorkteamArgs(
        description = description,
        memberDefinitions = memberDefinitions,
        notificationConfiguration = notificationConfiguration,
        tags = tags,
        workforceName = workforceName,
        workteamName = workteamName,
    )
}
