@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fileSystemConfig The URL where the Git repository is located. See File System Config details below.
 * @property kernelSpec The default branch for the Git repository. See Kernel Spec details below.
 */
public data class AppImageConfigKernelGatewayImageConfigArgs(
    public val fileSystemConfig: Output<AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs>? =
        null,
    public val kernelSpec: Output<AppImageConfigKernelGatewayImageConfigKernelSpecArgs>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs =
        com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs.builder()
            .fileSystemConfig(fileSystemConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kernelSpec(kernelSpec.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AppImageConfigKernelGatewayImageConfigArgs].
 */
@PulumiTagMarker
public class AppImageConfigKernelGatewayImageConfigArgsBuilder internal constructor() {
    private var fileSystemConfig: Output<AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs>? =
        null

    private var kernelSpec: Output<AppImageConfigKernelGatewayImageConfigKernelSpecArgs>? = null

    /**
     * @param value The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("rsljxilrfydxirdu")
    public suspend
    fun fileSystemConfig(`value`: Output<AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs>) {
        this.fileSystemConfig = value
    }

    /**
     * @param value The default branch for the Git repository. See Kernel Spec details below.
     */
    @JvmName("jlxpvrqpxdncmndd")
    public suspend
    fun kernelSpec(`value`: Output<AppImageConfigKernelGatewayImageConfigKernelSpecArgs>) {
        this.kernelSpec = value
    }

    /**
     * @param value The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("olvvshkpndjajnot")
    public suspend
    fun fileSystemConfig(`value`: AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemConfig = mapped
    }

    /**
     * @param argument The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("rlhhnbacvpvjvgsb")
    public suspend
    fun fileSystemConfig(argument: suspend AppImageConfigKernelGatewayImageConfigFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            AppImageConfigKernelGatewayImageConfigFileSystemConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fileSystemConfig = mapped
    }

    /**
     * @param value The default branch for the Git repository. See Kernel Spec details below.
     */
    @JvmName("jgjpqcedqcghjhpm")
    public suspend fun kernelSpec(`value`: AppImageConfigKernelGatewayImageConfigKernelSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kernelSpec = mapped
    }

    /**
     * @param argument The default branch for the Git repository. See Kernel Spec details below.
     */
    @JvmName("yjacmgexwwunwisd")
    public suspend
    fun kernelSpec(argument: suspend AppImageConfigKernelGatewayImageConfigKernelSpecArgsBuilder.() -> Unit) {
        val toBeMapped = AppImageConfigKernelGatewayImageConfigKernelSpecArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelSpec = mapped
    }

    internal fun build(): AppImageConfigKernelGatewayImageConfigArgs =
        AppImageConfigKernelGatewayImageConfigArgs(
            fileSystemConfig = fileSystemConfig,
            kernelSpec = kernelSpec ?: throw PulumiNullFieldException("kernelSpec"),
        )
}
