@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property displayName The display name of the kernel.
 * @property name The name of the kernel.
 */
public data class AppImageConfigKernelGatewayImageConfigKernelSpecArgs(
    public val displayName: Output<String>? = null,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs =
        com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigKernelSpecArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppImageConfigKernelGatewayImageConfigKernelSpecArgs].
 */
@PulumiTagMarker
public class AppImageConfigKernelGatewayImageConfigKernelSpecArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The display name of the kernel.
     */
    @JvmName("cghnyvypbdhpxgbv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the kernel.
     */
    @JvmName("cuxyojbtbifbsjck")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The display name of the kernel.
     */
    @JvmName("gjajfrlcudypncqw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the kernel.
     */
    @JvmName("mpefkfqqtnlvhpxe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AppImageConfigKernelGatewayImageConfigKernelSpecArgs =
        AppImageConfigKernelGatewayImageConfigKernelSpecArgs(
            displayName = displayName,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
