@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property constraintsResource The constraints resource for a monitoring job. Fields are documented below.
 * @property statisticsResource The statistics resource for a monitoring job. Fields are documented below.
 */
public data class DataQualityJobDefinitionDataQualityBaselineConfigArgs(
    public val constraintsResource:
    Output<DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs>? = null,
    public val statisticsResource:
    Output<DataQualityJobDefinitionDataQualityBaselineConfigStatisticsResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigArgs.builder()
            .constraintsResource(
                constraintsResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .statisticsResource(
                statisticsResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityBaselineConfigArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityBaselineConfigArgsBuilder internal constructor() {
    private var constraintsResource:
        Output<DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs>? = null

    private var statisticsResource:
        Output<DataQualityJobDefinitionDataQualityBaselineConfigStatisticsResourceArgs>? = null

    /**
     * @param value The constraints resource for a monitoring job. Fields are documented below.
     */
    @JvmName("tudivipiayipxkan")
    public suspend
    fun constraintsResource(`value`: Output<DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs>) {
        this.constraintsResource = value
    }

    /**
     * @param value The statistics resource for a monitoring job. Fields are documented below.
     */
    @JvmName("txuposxbalbyjykx")
    public suspend
    fun statisticsResource(`value`: Output<DataQualityJobDefinitionDataQualityBaselineConfigStatisticsResourceArgs>) {
        this.statisticsResource = value
    }

    /**
     * @param value The constraints resource for a monitoring job. Fields are documented below.
     */
    @JvmName("dxfckljfqimxccqa")
    public suspend
    fun constraintsResource(`value`: DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constraintsResource = mapped
    }

    /**
     * @param argument The constraints resource for a monitoring job. Fields are documented below.
     */
    @JvmName("venyoyyuoleatfbv")
    public suspend
    fun constraintsResource(argument: suspend DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.constraintsResource = mapped
    }

    /**
     * @param value The statistics resource for a monitoring job. Fields are documented below.
     */
    @JvmName("blncynuuyxhteleq")
    public suspend
    fun statisticsResource(`value`: DataQualityJobDefinitionDataQualityBaselineConfigStatisticsResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statisticsResource = mapped
    }

    /**
     * @param argument The statistics resource for a monitoring job. Fields are documented below.
     */
    @JvmName("aohflosjmxfydtbx")
    public suspend
    fun statisticsResource(argument: suspend DataQualityJobDefinitionDataQualityBaselineConfigStatisticsResourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityBaselineConfigStatisticsResourceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.statisticsResource = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityBaselineConfigArgs =
        DataQualityJobDefinitionDataQualityBaselineConfigArgs(
            constraintsResource = constraintsResource,
            statisticsResource = statisticsResource,
        )
}
